/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.glue.Column;
import software.amazon.awscdk.services.glue.DataFormat;
import software.amazon.awscdk.services.glue.IDatabase;
import software.amazon.awscdk.services.glue.ITable;
import software.amazon.awscdk.services.glue.TableAttributes;
import software.amazon.awscdk.services.glue.TableEncryption;
import software.amazon.awscdk.services.glue.TableProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.Table")
public class Table
extends Resource
implements ITable {
    protected Table(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Table(@NotNull Construct scope, @NotNull String id, @NotNull TableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITable fromTableArn(@NotNull Construct scope, @NotNull String id, @NotNull String tableArn) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableArn", ITable.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableArn, "tableArn is required")});
    }

    @NotNull
    public static ITable fromTableAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TableAttributes attrs) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableAttributes", ITable.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public IBucket getBucket() {
        return (IBucket)this.jsiiGet("bucket", IBucket.class);
    }

    @NotNull
    public List<Column> getColumns() {
        return Collections.unmodifiableList((List)this.jsiiGet("columns", NativeType.listOf((NativeType)NativeType.forClass(Column.class))));
    }

    @NotNull
    public Boolean getCompressed() {
        return (Boolean)this.jsiiGet("compressed", Boolean.class);
    }

    @NotNull
    public IDatabase getDatabase() {
        return (IDatabase)this.jsiiGet("database", IDatabase.class);
    }

    @NotNull
    public DataFormat getDataFormat() {
        return (DataFormat)((Object)this.jsiiGet("dataFormat", DataFormat.class));
    }

    @NotNull
    public TableEncryption getEncryption() {
        return (TableEncryption)((Object)this.jsiiGet("encryption", TableEncryption.class));
    }

    @NotNull
    public String getS3Prefix() {
        return (String)this.jsiiGet("s3Prefix", String.class);
    }

    @Override
    @NotNull
    public String getTableArn() {
        return (String)this.jsiiGet("tableArn", String.class);
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)this.jsiiGet("tableName", String.class);
    }

    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)this.jsiiGet("encryptionKey", IKey.class);
    }

    @Nullable
    public List<Column> getPartitionKeys() {
        return Optional.ofNullable((List)this.jsiiGet("partitionKeys", NativeType.listOf((NativeType)NativeType.forClass(Column.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Table> {
        private final Construct scope;
        private final String id;
        private final TableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TableProps.Builder();
        }

        public Builder columns(List<Column> columns) {
            this.props.columns(columns);
            return this;
        }

        public Builder database(IDatabase database) {
            this.props.database(database);
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.props.dataFormat(dataFormat);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder bucket(IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        public Builder compressed(Boolean compressed) {
            this.props.compressed(compressed);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder partitionKeys(List<Column> partitionKeys) {
            this.props.partitionKeys(partitionKeys);
            return this;
        }

        public Builder s3Prefix(String s3Prefix) {
            this.props.s3Prefix(s3Prefix);
            return this;
        }

        public Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.props.storedAsSubDirectories(storedAsSubDirectories);
            return this;
        }

        public Table build() {
            return new Table(this.scope, this.id, this.props.build());
        }
    }
}

