/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration;
import software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfigurationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_imagebuilder.CfnInfrastructureConfiguration")
public class CfnInfrastructureConfiguration
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInfrastructureConfiguration.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnInfrastructureConfiguration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInfrastructureConfiguration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInfrastructureConfiguration(@NotNull Construct scope, @NotNull String id, @NotNull CfnInfrastructureConfigurationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getInstanceProfileName() {
        return (String)this.jsiiGet("instanceProfileName", String.class);
    }

    public void setInstanceProfileName(@NotNull String value) {
        this.jsiiSet("instanceProfileName", Objects.requireNonNull(value, "instanceProfileName is required"));
    }

    @NotNull
    public Object getLogging() {
        return this.jsiiGet("logging", Object.class);
    }

    public void setLogging(@NotNull Object value) {
        this.jsiiSet("logging", Objects.requireNonNull(value, "logging is required"));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public List<String> getInstanceTypes() {
        return Optional.ofNullable((List)this.jsiiGet("instanceTypes", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setInstanceTypes(@Nullable List<String> value) {
        this.jsiiSet("instanceTypes", value);
    }

    @Nullable
    public String getKeyPair() {
        return (String)this.jsiiGet("keyPair", String.class);
    }

    public void setKeyPair(@Nullable String value) {
        this.jsiiSet("keyPair", value);
    }

    @Nullable
    public Object getResourceTags() {
        return this.jsiiGet("resourceTags", Object.class);
    }

    public void setResourceTags(@Nullable IResolvable value) {
        this.jsiiSet("resourceTags", value);
    }

    public void setResourceTags(@Nullable Map<String, String> value) {
        this.jsiiSet("resourceTags", value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)this.jsiiGet("securityGroupIds", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        this.jsiiSet("securityGroupIds", value);
    }

    @Nullable
    public String getSnsTopicArn() {
        return (String)this.jsiiGet("snsTopicArn", String.class);
    }

    public void setSnsTopicArn(@Nullable String value) {
        this.jsiiSet("snsTopicArn", value);
    }

    @Nullable
    public String getSubnetId() {
        return (String)this.jsiiGet("subnetId", String.class);
    }

    public void setSubnetId(@Nullable String value) {
        this.jsiiSet("subnetId", value);
    }

    @Nullable
    public Object getTerminateInstanceOnFailure() {
        return this.jsiiGet("terminateInstanceOnFailure", Object.class);
    }

    public void setTerminateInstanceOnFailure(@Nullable Boolean value) {
        this.jsiiSet("terminateInstanceOnFailure", value);
    }

    public void setTerminateInstanceOnFailure(@Nullable IResolvable value) {
        this.jsiiSet("terminateInstanceOnFailure", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInfrastructureConfiguration> {
        private final Construct scope;
        private final String id;
        private final CfnInfrastructureConfigurationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInfrastructureConfigurationProps.Builder();
        }

        public Builder instanceProfileName(String instanceProfileName) {
            this.props.instanceProfileName(instanceProfileName);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder instanceTypes(List<String> instanceTypes) {
            this.props.instanceTypes(instanceTypes);
            return this;
        }

        public Builder keyPair(String keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        public Builder logging(Object logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder resourceTags(IResolvable resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        public Builder resourceTags(Map<String, String> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder snsTopicArn(String snsTopicArn) {
            this.props.snsTopicArn(snsTopicArn);
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.props.subnetId(subnetId);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.props.terminateInstanceOnFailure(terminateInstanceOnFailure);
            return this;
        }

        public Builder terminateInstanceOnFailure(IResolvable terminateInstanceOnFailure) {
            this.props.terminateInstanceOnFailure(terminateInstanceOnFailure);
            return this;
        }

        public CfnInfrastructureConfiguration build() {
            return new CfnInfrastructureConfiguration(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_imagebuilder.CfnInfrastructureConfiguration.S3LogsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LogsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3BucketName() {
            return null;
        }

        @Nullable
        default public String getS3KeyPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LogsProperty> {
            private String s3BucketName;
            private String s3KeyPrefix;

            public Builder s3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Builder s3KeyPrefix(String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            public S3LogsProperty build() {
                return new Jsii.Proxy(this.s3BucketName, this.s3KeyPrefix, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_imagebuilder.CfnInfrastructureConfiguration.LoggingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3Logs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingProperty> {
            private Object s3Logs;

            public Builder s3Logs(S3LogsProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            public Builder s3Logs(IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            public LoggingProperty build() {
                return new Jsii.Proxy(this.s3Logs, null);
            }
        }
    }
}

