/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iot;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.iot.CfnTopicRule;
import software.amazon.awscdk.services.iot.CfnTopicRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule")
public class CfnTopicRule
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTopicRule.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnTopicRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTopicRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTopicRule(@NotNull Construct scope, @NotNull String id, @NotNull CfnTopicRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getTopicRulePayload() {
        return this.jsiiGet("topicRulePayload", Object.class);
    }

    public void setTopicRulePayload(@NotNull TopicRulePayloadProperty value) {
        this.jsiiSet("topicRulePayload", Objects.requireNonNull(value, "topicRulePayload is required"));
    }

    public void setTopicRulePayload(@NotNull IResolvable value) {
        this.jsiiSet("topicRulePayload", Objects.requireNonNull(value, "topicRulePayload is required"));
    }

    @Nullable
    public String getRuleName() {
        return (String)this.jsiiGet("ruleName", String.class);
    }

    public void setRuleName(@Nullable String value) {
        this.jsiiSet("ruleName", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTopicRule> {
        private final Construct scope;
        private final String id;
        private final CfnTopicRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTopicRuleProps.Builder();
        }

        public Builder topicRulePayload(TopicRulePayloadProperty topicRulePayload) {
            this.props.topicRulePayload(topicRulePayload);
            return this;
        }

        public Builder topicRulePayload(IResolvable topicRulePayload) {
            this.props.topicRulePayload(topicRulePayload);
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        public CfnTopicRule build() {
            return new CfnTopicRule(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.TopicRulePayloadProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicRulePayloadProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActions();

        @NotNull
        public Object getRuleDisabled();

        @NotNull
        public String getSql();

        @Nullable
        default public String getAwsIotSqlVersion() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getErrorAction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopicRulePayloadProperty> {
            private Object actions;
            private Object ruleDisabled;
            private String sql;
            private String awsIotSqlVersion;
            private String description;
            private Object errorAction;

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder ruleDisabled(Boolean ruleDisabled) {
                this.ruleDisabled = ruleDisabled;
                return this;
            }

            public Builder ruleDisabled(IResolvable ruleDisabled) {
                this.ruleDisabled = ruleDisabled;
                return this;
            }

            public Builder sql(String sql) {
                this.sql = sql;
                return this;
            }

            public Builder awsIotSqlVersion(String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder errorAction(ActionProperty errorAction) {
                this.errorAction = errorAction;
                return this;
            }

            public Builder errorAction(IResolvable errorAction) {
                this.errorAction = errorAction;
                return this;
            }

            public TopicRulePayloadProperty build() {
                return new Jsii.Proxy(this.actions, this.ruleDisabled, this.sql, this.awsIotSqlVersion, this.description, this.errorAction, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.StepFunctionsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StepFunctionsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getStateMachineName();

        @Nullable
        default public String getExecutionNamePrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StepFunctionsActionProperty> {
            private String roleArn;
            private String stateMachineName;
            private String executionNamePrefix;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder stateMachineName(String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            public Builder executionNamePrefix(String executionNamePrefix) {
                this.executionNamePrefix = executionNamePrefix;
                return this;
            }

            public StepFunctionsActionProperty build() {
                return new Jsii.Proxy(this.roleArn, this.stateMachineName, this.executionNamePrefix, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.SqsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueueUrl();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getUseBase64() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqsActionProperty> {
            private String queueUrl;
            private String roleArn;
            private Object useBase64;

            public Builder queueUrl(String queueUrl) {
                this.queueUrl = queueUrl;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder useBase64(Boolean useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            public Builder useBase64(IResolvable useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            public SqsActionProperty build() {
                return new Jsii.Proxy(this.queueUrl, this.roleArn, this.useBase64, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.SnsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTargetArn();

        @Nullable
        default public String getMessageFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnsActionProperty> {
            private String roleArn;
            private String targetArn;
            private String messageFormat;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Builder messageFormat(String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            public SnsActionProperty build() {
                return new Jsii.Proxy(this.roleArn, this.targetArn, this.messageFormat, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.SigV4AuthorizationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SigV4AuthorizationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getServiceName();

        @NotNull
        public String getSigningRegion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SigV4AuthorizationProperty> {
            private String roleArn;
            private String serviceName;
            private String signingRegion;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder signingRegion(String signingRegion) {
                this.signingRegion = signingRegion;
                return this;
            }

            public SigV4AuthorizationProperty build() {
                return new Jsii.Proxy(this.roleArn, this.serviceName, this.signingRegion, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.S3ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getKey();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ActionProperty> {
            private String bucketName;
            private String key;
            private String roleArn;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public S3ActionProperty build() {
                return new Jsii.Proxy(this.bucketName, this.key, this.roleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.RepublishActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepublishActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTopic();

        @Nullable
        default public Number getQos() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepublishActionProperty> {
            private String roleArn;
            private String topic;
            private Number qos;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder qos(Number qos) {
                this.qos = qos;
                return this;
            }

            public RepublishActionProperty build() {
                return new Jsii.Proxy(this.roleArn, this.topic, this.qos, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.PutItemInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PutItemInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PutItemInputProperty> {
            private String tableName;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public PutItemInputProperty build() {
                return new Jsii.Proxy(this.tableName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.PutAssetPropertyValueEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PutAssetPropertyValueEntryProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPropertyValues();

        @Nullable
        default public String getAssetId() {
            return null;
        }

        @Nullable
        default public String getEntryId() {
            return null;
        }

        @Nullable
        default public String getPropertyAlias() {
            return null;
        }

        @Nullable
        default public String getPropertyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PutAssetPropertyValueEntryProperty> {
            private Object propertyValues;
            private String assetId;
            private String entryId;
            private String propertyAlias;
            private String propertyId;

            public Builder propertyValues(IResolvable propertyValues) {
                this.propertyValues = propertyValues;
                return this;
            }

            public Builder propertyValues(List<Object> propertyValues) {
                this.propertyValues = propertyValues;
                return this;
            }

            public Builder assetId(String assetId) {
                this.assetId = assetId;
                return this;
            }

            public Builder entryId(String entryId) {
                this.entryId = entryId;
                return this;
            }

            public Builder propertyAlias(String propertyAlias) {
                this.propertyAlias = propertyAlias;
                return this;
            }

            public Builder propertyId(String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            public PutAssetPropertyValueEntryProperty build() {
                return new Jsii.Proxy(this.propertyValues, this.assetId, this.entryId, this.propertyAlias, this.propertyId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.LambdaActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaActionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFunctionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaActionProperty> {
            private String functionArn;

            public Builder functionArn(String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            public LambdaActionProperty build() {
                return new Jsii.Proxy(this.functionArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.KinesisActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getStreamName();

        @Nullable
        default public String getPartitionKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisActionProperty> {
            private String roleArn;
            private String streamName;
            private String partitionKey;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public Builder partitionKey(String partitionKey) {
                this.partitionKey = partitionKey;
                return this;
            }

            public KinesisActionProperty build() {
                return new Jsii.Proxy(this.roleArn, this.streamName, this.partitionKey, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.IotSiteWiseActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotSiteWiseActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPutAssetPropertyValueEntries();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotSiteWiseActionProperty> {
            private Object putAssetPropertyValueEntries;
            private String roleArn;

            public Builder putAssetPropertyValueEntries(IResolvable putAssetPropertyValueEntries) {
                this.putAssetPropertyValueEntries = putAssetPropertyValueEntries;
                return this;
            }

            public Builder putAssetPropertyValueEntries(List<Object> putAssetPropertyValueEntries) {
                this.putAssetPropertyValueEntries = putAssetPropertyValueEntries;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public IotSiteWiseActionProperty build() {
                return new Jsii.Proxy(this.putAssetPropertyValueEntries, this.roleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.IotEventsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotEventsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getInputName();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getMessageId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotEventsActionProperty> {
            private String inputName;
            private String roleArn;
            private String messageId;

            public Builder inputName(String inputName) {
                this.inputName = inputName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder messageId(String messageId) {
                this.messageId = messageId;
                return this;
            }

            public IotEventsActionProperty build() {
                return new Jsii.Proxy(this.inputName, this.roleArn, this.messageId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.IotAnalyticsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotAnalyticsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getChannelName();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotAnalyticsActionProperty> {
            private String channelName;
            private String roleArn;

            public Builder channelName(String channelName) {
                this.channelName = channelName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public IotAnalyticsActionProperty build() {
                return new Jsii.Proxy(this.channelName, this.roleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.HttpAuthorizationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpAuthorizationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSigv4() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpAuthorizationProperty> {
            private Object sigv4;

            public Builder sigv4(SigV4AuthorizationProperty sigv4) {
                this.sigv4 = sigv4;
                return this;
            }

            public Builder sigv4(IResolvable sigv4) {
                this.sigv4 = sigv4;
                return this;
            }

            public HttpAuthorizationProperty build() {
                return new Jsii.Proxy(this.sigv4, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.HttpActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getUrl();

        @Nullable
        default public Object getAuth() {
            return null;
        }

        @Nullable
        default public String getConfirmationUrl() {
            return null;
        }

        @Nullable
        default public Object getHeaders() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpActionProperty> {
            private String url;
            private Object auth;
            private String confirmationUrl;
            private Object headers;

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder auth(HttpAuthorizationProperty auth) {
                this.auth = auth;
                return this;
            }

            public Builder auth(IResolvable auth) {
                this.auth = auth;
                return this;
            }

            public Builder confirmationUrl(String confirmationUrl) {
                this.confirmationUrl = confirmationUrl;
                return this;
            }

            public Builder headers(IResolvable headers) {
                this.headers = headers;
                return this;
            }

            public Builder headers(List<Object> headers) {
                this.headers = headers;
                return this;
            }

            public HttpActionProperty build() {
                return new Jsii.Proxy(this.url, this.auth, this.confirmationUrl, this.headers, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.HttpActionHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpActionHeaderProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpActionHeaderProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public HttpActionHeaderProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.FirehoseActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirehoseActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getDeliveryStreamName();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getSeparator() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirehoseActionProperty> {
            private String deliveryStreamName;
            private String roleArn;
            private String separator;

            public Builder deliveryStreamName(String deliveryStreamName) {
                this.deliveryStreamName = deliveryStreamName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public FirehoseActionProperty build() {
                return new Jsii.Proxy(this.deliveryStreamName, this.roleArn, this.separator, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.ElasticsearchActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpoint();

        @NotNull
        public String getId();

        @NotNull
        public String getIndex();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchActionProperty> {
            private String endpoint;
            private String id;
            private String index;
            private String roleArn;
            private String type;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder index(String index) {
                this.index = index;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticsearchActionProperty build() {
                return new Jsii.Proxy(this.endpoint, this.id, this.index, this.roleArn, this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.DynamoDBv2ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBv2ActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPutItem() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBv2ActionProperty> {
            private Object putItem;
            private String roleArn;

            public Builder putItem(PutItemInputProperty putItem) {
                this.putItem = putItem;
                return this;
            }

            public Builder putItem(IResolvable putItem) {
                this.putItem = putItem;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public DynamoDBv2ActionProperty build() {
                return new Jsii.Proxy(this.putItem, this.roleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.DynamoDBActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getHashKeyField();

        @NotNull
        public String getHashKeyValue();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTableName();

        @Nullable
        default public String getHashKeyType() {
            return null;
        }

        @Nullable
        default public String getPayloadField() {
            return null;
        }

        @Nullable
        default public String getRangeKeyField() {
            return null;
        }

        @Nullable
        default public String getRangeKeyType() {
            return null;
        }

        @Nullable
        default public String getRangeKeyValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBActionProperty> {
            private String hashKeyField;
            private String hashKeyValue;
            private String roleArn;
            private String tableName;
            private String hashKeyType;
            private String payloadField;
            private String rangeKeyField;
            private String rangeKeyType;
            private String rangeKeyValue;

            public Builder hashKeyField(String hashKeyField) {
                this.hashKeyField = hashKeyField;
                return this;
            }

            public Builder hashKeyValue(String hashKeyValue) {
                this.hashKeyValue = hashKeyValue;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder hashKeyType(String hashKeyType) {
                this.hashKeyType = hashKeyType;
                return this;
            }

            public Builder payloadField(String payloadField) {
                this.payloadField = payloadField;
                return this;
            }

            public Builder rangeKeyField(String rangeKeyField) {
                this.rangeKeyField = rangeKeyField;
                return this;
            }

            public Builder rangeKeyType(String rangeKeyType) {
                this.rangeKeyType = rangeKeyType;
                return this;
            }

            public Builder rangeKeyValue(String rangeKeyValue) {
                this.rangeKeyValue = rangeKeyValue;
                return this;
            }

            public DynamoDBActionProperty build() {
                return new Jsii.Proxy(this.hashKeyField, this.hashKeyValue, this.roleArn, this.tableName, this.hashKeyType, this.payloadField, this.rangeKeyField, this.rangeKeyType, this.rangeKeyValue, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.CloudwatchMetricActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchMetricActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getMetricName();

        @NotNull
        public String getMetricNamespace();

        @NotNull
        public String getMetricUnit();

        @NotNull
        public String getMetricValue();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getMetricTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchMetricActionProperty> {
            private String metricName;
            private String metricNamespace;
            private String metricUnit;
            private String metricValue;
            private String roleArn;
            private String metricTimestamp;

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder metricNamespace(String metricNamespace) {
                this.metricNamespace = metricNamespace;
                return this;
            }

            public Builder metricUnit(String metricUnit) {
                this.metricUnit = metricUnit;
                return this;
            }

            public Builder metricValue(String metricValue) {
                this.metricValue = metricValue;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder metricTimestamp(String metricTimestamp) {
                this.metricTimestamp = metricTimestamp;
                return this;
            }

            public CloudwatchMetricActionProperty build() {
                return new Jsii.Proxy(this.metricName, this.metricNamespace, this.metricUnit, this.metricValue, this.roleArn, this.metricTimestamp, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.CloudwatchAlarmActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchAlarmActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getAlarmName();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getStateReason();

        @NotNull
        public String getStateValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchAlarmActionProperty> {
            private String alarmName;
            private String roleArn;
            private String stateReason;
            private String stateValue;

            public Builder alarmName(String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder stateReason(String stateReason) {
                this.stateReason = stateReason;
                return this;
            }

            public Builder stateValue(String stateValue) {
                this.stateValue = stateValue;
                return this;
            }

            public CloudwatchAlarmActionProperty build() {
                return new Jsii.Proxy(this.alarmName, this.roleArn, this.stateReason, this.stateValue, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.AssetPropertyVariantProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyVariantProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBooleanValue() {
            return null;
        }

        @Nullable
        default public String getDoubleValue() {
            return null;
        }

        @Nullable
        default public String getIntegerValue() {
            return null;
        }

        @Nullable
        default public String getStringValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyVariantProperty> {
            private String booleanValue;
            private String doubleValue;
            private String integerValue;
            private String stringValue;

            public Builder booleanValue(String booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            public Builder doubleValue(String doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            public Builder integerValue(String integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            public Builder stringValue(String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            public AssetPropertyVariantProperty build() {
                return new Jsii.Proxy(this.booleanValue, this.doubleValue, this.integerValue, this.stringValue, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.AssetPropertyValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyValueProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTimestamp();

        @NotNull
        public Object getValue();

        @Nullable
        default public String getQuality() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyValueProperty> {
            private Object timestamp;
            private Object value;
            private String quality;

            public Builder timestamp(AssetPropertyTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder timestamp(IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder value(AssetPropertyVariantProperty value) {
                this.value = value;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder quality(String quality) {
                this.quality = quality;
                return this;
            }

            public AssetPropertyValueProperty build() {
                return new Jsii.Proxy(this.timestamp, this.value, this.quality, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.AssetPropertyTimestampProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyTimestampProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimeInSeconds();

        @Nullable
        default public String getOffsetInNanos() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyTimestampProperty> {
            private String timeInSeconds;
            private String offsetInNanos;

            public Builder timeInSeconds(String timeInSeconds) {
                this.timeInSeconds = timeInSeconds;
                return this;
            }

            public Builder offsetInNanos(String offsetInNanos) {
                this.offsetInNanos = offsetInNanos;
                return this;
            }

            public AssetPropertyTimestampProperty build() {
                return new Jsii.Proxy(this.timeInSeconds, this.offsetInNanos, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_iot.CfnTopicRule.ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudwatchAlarm() {
            return null;
        }

        @Nullable
        default public Object getCloudwatchMetric() {
            return null;
        }

        @Nullable
        default public Object getDynamoDb() {
            return null;
        }

        @Nullable
        default public Object getDynamoDBv2() {
            return null;
        }

        @Nullable
        default public Object getElasticsearch() {
            return null;
        }

        @Nullable
        default public Object getFirehose() {
            return null;
        }

        @Nullable
        default public Object getHttp() {
            return null;
        }

        @Nullable
        default public Object getIotAnalytics() {
            return null;
        }

        @Nullable
        default public Object getIotEvents() {
            return null;
        }

        @Nullable
        default public Object getIotSiteWise() {
            return null;
        }

        @Nullable
        default public Object getKinesis() {
            return null;
        }

        @Nullable
        default public Object getLambda() {
            return null;
        }

        @Nullable
        default public Object getRepublish() {
            return null;
        }

        @Nullable
        default public Object getS3() {
            return null;
        }

        @Nullable
        default public Object getSns() {
            return null;
        }

        @Nullable
        default public Object getSqs() {
            return null;
        }

        @Nullable
        default public Object getStepFunctions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionProperty> {
            private Object cloudwatchAlarm;
            private Object cloudwatchMetric;
            private Object dynamoDb;
            private Object dynamoDBv2;
            private Object elasticsearch;
            private Object firehose;
            private Object http;
            private Object iotAnalytics;
            private Object iotEvents;
            private Object iotSiteWise;
            private Object kinesis;
            private Object lambda;
            private Object republish;
            private Object s3;
            private Object sns;
            private Object sqs;
            private Object stepFunctions;

            public Builder cloudwatchAlarm(CloudwatchAlarmActionProperty cloudwatchAlarm) {
                this.cloudwatchAlarm = cloudwatchAlarm;
                return this;
            }

            public Builder cloudwatchAlarm(IResolvable cloudwatchAlarm) {
                this.cloudwatchAlarm = cloudwatchAlarm;
                return this;
            }

            public Builder cloudwatchMetric(CloudwatchMetricActionProperty cloudwatchMetric) {
                this.cloudwatchMetric = cloudwatchMetric;
                return this;
            }

            public Builder cloudwatchMetric(IResolvable cloudwatchMetric) {
                this.cloudwatchMetric = cloudwatchMetric;
                return this;
            }

            public Builder dynamoDb(DynamoDBActionProperty dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            public Builder dynamoDb(IResolvable dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            public Builder dynamoDBv2(DynamoDBv2ActionProperty dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            public Builder dynamoDBv2(IResolvable dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            public Builder elasticsearch(ElasticsearchActionProperty elasticsearch) {
                this.elasticsearch = elasticsearch;
                return this;
            }

            public Builder elasticsearch(IResolvable elasticsearch) {
                this.elasticsearch = elasticsearch;
                return this;
            }

            public Builder firehose(FirehoseActionProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder firehose(IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder http(HttpActionProperty http) {
                this.http = http;
                return this;
            }

            public Builder http(IResolvable http) {
                this.http = http;
                return this;
            }

            public Builder iotAnalytics(IotAnalyticsActionProperty iotAnalytics) {
                this.iotAnalytics = iotAnalytics;
                return this;
            }

            public Builder iotAnalytics(IResolvable iotAnalytics) {
                this.iotAnalytics = iotAnalytics;
                return this;
            }

            public Builder iotEvents(IotEventsActionProperty iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            public Builder iotEvents(IResolvable iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            public Builder iotSiteWise(IotSiteWiseActionProperty iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            public Builder iotSiteWise(IResolvable iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            public Builder kinesis(KinesisActionProperty kinesis) {
                this.kinesis = kinesis;
                return this;
            }

            public Builder kinesis(IResolvable kinesis) {
                this.kinesis = kinesis;
                return this;
            }

            public Builder lambda(LambdaActionProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder lambda(IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder republish(RepublishActionProperty republish) {
                this.republish = republish;
                return this;
            }

            public Builder republish(IResolvable republish) {
                this.republish = republish;
                return this;
            }

            public Builder s3(S3ActionProperty s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder sns(SnsActionProperty sns) {
                this.sns = sns;
                return this;
            }

            public Builder sns(IResolvable sns) {
                this.sns = sns;
                return this;
            }

            public Builder sqs(SqsActionProperty sqs) {
                this.sqs = sqs;
                return this;
            }

            public Builder sqs(IResolvable sqs) {
                this.sqs = sqs;
                return this;
            }

            public Builder stepFunctions(StepFunctionsActionProperty stepFunctions) {
                this.stepFunctions = stepFunctions;
                return this;
            }

            public Builder stepFunctions(IResolvable stepFunctions) {
                this.stepFunctions = stepFunctions;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this.cloudwatchAlarm, this.cloudwatchMetric, this.dynamoDb, this.dynamoDBv2, this.elasticsearch, this.firehose, this.http, this.iotAnalytics, this.iotEvents, this.iotSiteWise, this.kinesis, this.lambda, this.republish, this.s3, this.sns, this.sqs, this.stepFunctions, null);
            }
        }
    }
}

