/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisanalytics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource")
public class CfnApplicationReferenceDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplicationReferenceDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnApplicationReferenceDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationReferenceDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplicationReferenceDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationReferenceDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationName() {
        return (String)this.jsiiGet("applicationName", String.class);
    }

    public void setApplicationName(@NotNull String value) {
        this.jsiiSet("applicationName", Objects.requireNonNull(value, "applicationName is required"));
    }

    @NotNull
    public Object getReferenceDataSource() {
        return this.jsiiGet("referenceDataSource", Object.class);
    }

    public void setReferenceDataSource(@NotNull ReferenceDataSourceProperty value) {
        this.jsiiSet("referenceDataSource", Objects.requireNonNull(value, "referenceDataSource is required"));
    }

    public void setReferenceDataSource(@NotNull IResolvable value) {
        this.jsiiSet("referenceDataSource", Objects.requireNonNull(value, "referenceDataSource is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplicationReferenceDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationReferenceDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationReferenceDataSourceProps.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder referenceDataSource(ReferenceDataSourceProperty referenceDataSource) {
            this.props.referenceDataSource(referenceDataSource);
            return this;
        }

        public Builder referenceDataSource(IResolvable referenceDataSource) {
            this.props.referenceDataSource(referenceDataSource);
            return this;
        }

        public CfnApplicationReferenceDataSource build() {
            return new CfnApplicationReferenceDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ReferenceDataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getFileKey();

        @NotNull
        public String getReferenceRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ReferenceDataSourceProperty> {
            private String bucketArn;
            private String fileKey;
            private String referenceRoleArn;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder fileKey(String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            public Builder referenceRoleArn(String referenceRoleArn) {
                this.referenceRoleArn = referenceRoleArn;
                return this;
            }

            public S3ReferenceDataSourceProperty build() {
                return new Jsii.Proxy(this.bucketArn, this.fileKey, this.referenceRoleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceSchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceSchemaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRecordColumns();

        @NotNull
        public Object getRecordFormat();

        @Nullable
        default public String getRecordEncoding() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceSchemaProperty> {
            private Object recordColumns;
            private Object recordFormat;
            private String recordEncoding;

            public Builder recordColumns(IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordColumns(List<Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordFormat(RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordFormat(IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordEncoding(String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            public ReferenceSchemaProperty build() {
                return new Jsii.Proxy(this.recordColumns, this.recordFormat, this.recordEncoding, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceDataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getReferenceSchema();

        @Nullable
        default public Object getS3ReferenceDataSource() {
            return null;
        }

        @Nullable
        default public String getTableName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceDataSourceProperty> {
            private Object referenceSchema;
            private Object s3ReferenceDataSource;
            private String tableName;

            public Builder referenceSchema(ReferenceSchemaProperty referenceSchema) {
                this.referenceSchema = referenceSchema;
                return this;
            }

            public Builder referenceSchema(IResolvable referenceSchema) {
                this.referenceSchema = referenceSchema;
                return this;
            }

            public Builder s3ReferenceDataSource(S3ReferenceDataSourceProperty s3ReferenceDataSource) {
                this.s3ReferenceDataSource = s3ReferenceDataSource;
                return this;
            }

            public Builder s3ReferenceDataSource(IResolvable s3ReferenceDataSource) {
                this.s3ReferenceDataSource = s3ReferenceDataSource;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public ReferenceDataSourceProperty build() {
                return new Jsii.Proxy(this.referenceSchema, this.s3ReferenceDataSource, this.tableName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.RecordFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordFormatProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordFormatType();

        @Nullable
        default public Object getMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordFormatProperty> {
            private String recordFormatType;
            private Object mappingParameters;

            public Builder recordFormatType(String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            public Builder mappingParameters(MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public Builder mappingParameters(IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public RecordFormatProperty build() {
                return new Jsii.Proxy(this.recordFormatType, this.mappingParameters, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.RecordColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordColumnProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSqlType();

        @Nullable
        default public String getMapping() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordColumnProperty> {
            private String name;
            private String sqlType;
            private String mapping;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sqlType(String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            public Builder mapping(String mapping) {
                this.mapping = mapping;
                return this;
            }

            public RecordColumnProperty build() {
                return new Jsii.Proxy(this.name, this.sqlType, this.mapping, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.MappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MappingParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsvMappingParameters() {
            return null;
        }

        @Nullable
        default public Object getJsonMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MappingParametersProperty> {
            private Object csvMappingParameters;
            private Object jsonMappingParameters;

            public Builder csvMappingParameters(CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder csvMappingParameters(IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public MappingParametersProperty build() {
                return new Jsii.Proxy(this.csvMappingParameters, this.jsonMappingParameters, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JSONMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordRowPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            private String recordRowPath;

            public Builder recordRowPath(String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            public JSONMappingParametersProperty build() {
                return new Jsii.Proxy(this.recordRowPath, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kinesisanalytics.CfnApplicationReferenceDataSource.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CSVMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordColumnDelimiter();

        @NotNull
        public String getRecordRowDelimiter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            private String recordColumnDelimiter;
            private String recordRowDelimiter;

            public Builder recordColumnDelimiter(String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            public Builder recordRowDelimiter(String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            public CSVMappingParametersProperty build() {
                return new Jsii.Proxy(this.recordColumnDelimiter, this.recordRowDelimiter, null);
            }
        }
    }
}

