/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.apigateway.AuthorizationType;
import software.amazon.awscdk.services.apigateway.IAuthorizer;
import software.amazon.awscdk.services.apigateway.IModel;
import software.amazon.awscdk.services.apigateway.IRequestValidator;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.MethodResponse;
import software.amazon.awscdk.services.apigateway.RequestValidatorOptions;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_lambda_event_sources.ApiEventSource")
public class ApiEventSource
extends JsiiObject
implements IEventSource {
    protected ApiEventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiEventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApiEventSource(@NotNull String method, @NotNull String path, @Nullable MethodOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(method, "method is required"), Objects.requireNonNull(path, "path is required"), options});
    }

    public ApiEventSource(@NotNull String method, @NotNull String path) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(method, "method is required"), Objects.requireNonNull(path, "path is required")});
    }

    @Override
    public void bind(@NotNull IFunction target) {
        this.jsiiCall("bind", NativeType.VOID, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApiEventSource> {
        private final String method;
        private final String path;
        private MethodOptions.Builder options;

        public static Builder create(String method, String path) {
            return new Builder(method, path);
        }

        private Builder(String method, String path) {
            this.method = method;
            this.path = path;
        }

        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.options().apiKeyRequired(apiKeyRequired);
            return this;
        }

        public Builder authorizationScopes(List<String> authorizationScopes) {
            this.options().authorizationScopes(authorizationScopes);
            return this;
        }

        public Builder authorizationType(AuthorizationType authorizationType) {
            this.options().authorizationType(authorizationType);
            return this;
        }

        public Builder authorizer(IAuthorizer authorizer) {
            this.options().authorizer(authorizer);
            return this;
        }

        public Builder methodResponses(List<MethodResponse> methodResponses) {
            this.options().methodResponses(methodResponses);
            return this;
        }

        public Builder operationName(String operationName) {
            this.options().operationName(operationName);
            return this;
        }

        public Builder requestModels(Map<String, IModel> requestModels) {
            this.options().requestModels(requestModels);
            return this;
        }

        public Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        public Builder requestValidator(IRequestValidator requestValidator) {
            this.options().requestValidator(requestValidator);
            return this;
        }

        public Builder requestValidatorOptions(RequestValidatorOptions requestValidatorOptions) {
            this.options().requestValidatorOptions(requestValidatorOptions);
            return this;
        }

        public ApiEventSource build() {
            return new ApiEventSource(this.method, this.path, this.options != null ? this.options.build() : null);
        }

        private MethodOptions.Builder options() {
            if (this.options == null) {
                this.options = new MethodOptions.Builder();
            }
            return this.options;
        }
    }
}

