/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.rds.CfnDBProxy;
import software.amazon.awscdk.services.rds.CfnDBProxyProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_rds.CfnDBProxy")
public class CfnDBProxy
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDBProxy.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnDBProxy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBProxy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDBProxy(@NotNull Construct scope, @NotNull String id, @NotNull CfnDBProxyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDbProxyArn() {
        return (String)this.jsiiGet("attrDbProxyArn", String.class);
    }

    @NotNull
    public String getAttrEndpoint() {
        return (String)this.jsiiGet("attrEndpoint", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getAuth() {
        return this.jsiiGet("auth", Object.class);
    }

    public void setAuth(@NotNull IResolvable value) {
        this.jsiiSet("auth", Objects.requireNonNull(value, "auth is required"));
    }

    public void setAuth(@NotNull List<Object> value) {
        this.jsiiSet("auth", Objects.requireNonNull(value, "auth is required"));
    }

    @NotNull
    public String getDbProxyName() {
        return (String)this.jsiiGet("dbProxyName", String.class);
    }

    public void setDbProxyName(@NotNull String value) {
        this.jsiiSet("dbProxyName", Objects.requireNonNull(value, "dbProxyName is required"));
    }

    @NotNull
    public String getEngineFamily() {
        return (String)this.jsiiGet("engineFamily", String.class);
    }

    public void setEngineFamily(@NotNull String value) {
        this.jsiiSet("engineFamily", Objects.requireNonNull(value, "engineFamily is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    public void setRoleArn(@NotNull String value) {
        this.jsiiSet("roleArn", Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public List<String> getVpcSubnetIds() {
        return Collections.unmodifiableList((List)this.jsiiGet("vpcSubnetIds", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setVpcSubnetIds(@NotNull List<String> value) {
        this.jsiiSet("vpcSubnetIds", Objects.requireNonNull(value, "vpcSubnetIds is required"));
    }

    @Nullable
    public Object getDebugLogging() {
        return this.jsiiGet("debugLogging", Object.class);
    }

    public void setDebugLogging(@Nullable Boolean value) {
        this.jsiiSet("debugLogging", value);
    }

    public void setDebugLogging(@Nullable IResolvable value) {
        this.jsiiSet("debugLogging", value);
    }

    @Nullable
    public Number getIdleClientTimeout() {
        return (Number)this.jsiiGet("idleClientTimeout", Number.class);
    }

    public void setIdleClientTimeout(@Nullable Number value) {
        this.jsiiSet("idleClientTimeout", value);
    }

    @Nullable
    public Object getRequireTls() {
        return this.jsiiGet("requireTls", Object.class);
    }

    public void setRequireTls(@Nullable Boolean value) {
        this.jsiiSet("requireTls", value);
    }

    public void setRequireTls(@Nullable IResolvable value) {
        this.jsiiSet("requireTls", value);
    }

    @Nullable
    public List<TagFormatProperty> getTags() {
        return Optional.ofNullable((List)this.jsiiGet("tags", NativeType.listOf((NativeType)NativeType.forClass(TagFormatProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<TagFormatProperty> value) {
        this.jsiiSet("tags", value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)this.jsiiGet("vpcSecurityGroupIds", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        this.jsiiSet("vpcSecurityGroupIds", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDBProxy> {
        private final Construct scope;
        private final String id;
        private final CfnDBProxyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDBProxyProps.Builder();
        }

        public Builder auth(IResolvable auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder auth(List<Object> auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder dbProxyName(String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        public Builder engineFamily(String engineFamily) {
            this.props.engineFamily(engineFamily);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder vpcSubnetIds(List<String> vpcSubnetIds) {
            this.props.vpcSubnetIds(vpcSubnetIds);
            return this;
        }

        public Builder debugLogging(Boolean debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        public Builder debugLogging(IResolvable debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        public Builder idleClientTimeout(Number idleClientTimeout) {
            this.props.idleClientTimeout(idleClientTimeout);
            return this;
        }

        public Builder requireTls(Boolean requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        public Builder requireTls(IResolvable requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        public Builder tags(List<TagFormatProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnDBProxy build() {
            return new CfnDBProxy(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_rds.CfnDBProxy.TagFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFormatProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagFormatProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFormatProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_rds.CfnDBProxy.AuthFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthFormatProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthScheme() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public String getIamAuth() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        @Nullable
        default public String getUserName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthFormatProperty> {
            private String authScheme;
            private String description;
            private String iamAuth;
            private String secretArn;
            private String userName;

            public Builder authScheme(String authScheme) {
                this.authScheme = authScheme;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder iamAuth(String iamAuth) {
                this.iamAuth = iamAuth;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder userName(String userName) {
                this.userName = userName;
                return this;
            }

            public AuthFormatProperty build() {
                return new Jsii.Proxy(this.authScheme, this.description, this.iamAuth, this.secretArn, this.userName, null);
            }
        }
    }
}

