/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.BackupProps;
import software.amazon.awscdk.services.rds.DatabaseClusterAttributes;
import software.amazon.awscdk.services.rds.DatabaseClusterProps;
import software.amazon.awscdk.services.rds.DatabaseProxy;
import software.amazon.awscdk.services.rds.DatabaseProxyOptions;
import software.amazon.awscdk.services.rds.Endpoint;
import software.amazon.awscdk.services.rds.IClusterEngine;
import software.amazon.awscdk.services.rds.IDatabaseCluster;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.InstanceProps;
import software.amazon.awscdk.services.rds.Login;
import software.amazon.awscdk.services.rds.RotationMultiUserOptions;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_rds.DatabaseCluster")
public class DatabaseCluster
extends Resource
implements IDatabaseCluster {
    protected DatabaseCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseCluster(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDatabaseCluster fromDatabaseClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterAttributes attrs) {
        return (IDatabaseCluster)JsiiObject.jsiiStaticCall(DatabaseCluster.class, (String)"fromDatabaseClusterAttributes", IDatabaseCluster.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public DatabaseProxy addProxy(@NotNull String id, @NotNull DatabaseProxyOptions options) {
        return (DatabaseProxy)this.jsiiCall("addProxy", DatabaseProxy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)this.jsiiCall("addRotationMultiUser", SecretRotation.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable Duration automaticallyAfter) {
        return (SecretRotation)this.jsiiCall("addRotationSingleUser", SecretRotation.class, new Object[]{automaticallyAfter});
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)this.jsiiCall("addRotationSingleUser", SecretRotation.class, new Object[0]);
    }

    @Override
    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)this.jsiiCall("asSecretAttachmentTarget", SecretAttachmentTargetProps.class, new Object[0]);
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)this.jsiiGet("clusterEndpoint", Endpoint.class));
    }

    @Override
    @NotNull
    public String getClusterIdentifier() {
        return (String)this.jsiiGet("clusterIdentifier", String.class);
    }

    @Override
    @NotNull
    public Endpoint getClusterReadEndpoint() {
        return (Endpoint)((Object)this.jsiiGet("clusterReadEndpoint", Endpoint.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public List<Endpoint> getInstanceEndpoints() {
        return Collections.unmodifiableList((List)this.jsiiGet("instanceEndpoints", NativeType.listOf((NativeType)NativeType.forClass(Endpoint.class))));
    }

    @Override
    @NotNull
    public List<String> getInstanceIdentifiers() {
        return Collections.unmodifiableList((List)this.jsiiGet("instanceIdentifiers", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)this.jsiiGet("secret", ISecret.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseCluster> {
        private final Construct scope;
        private final String id;
        private final DatabaseClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseClusterProps.Builder();
        }

        public Builder engine(IClusterEngine engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder instanceProps(InstanceProps instanceProps) {
            this.props.instanceProps(instanceProps);
            return this;
        }

        public Builder masterUser(Login masterUser) {
            this.props.masterUser(masterUser);
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        public Builder instances(Number instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder s3ExportBuckets(List<IBucket> s3ExportBuckets) {
            this.props.s3ExportBuckets(s3ExportBuckets);
            return this;
        }

        public Builder s3ExportRole(IRole s3ExportRole) {
            this.props.s3ExportRole(s3ExportRole);
            return this;
        }

        public Builder s3ImportBuckets(List<IBucket> s3ImportBuckets) {
            this.props.s3ImportBuckets(s3ImportBuckets);
            return this;
        }

        public Builder s3ImportRole(IRole s3ImportRole) {
            this.props.s3ImportRole(s3ImportRole);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        public DatabaseCluster build() {
            return new DatabaseCluster(this.scope, this.id, this.props.build());
        }
    }
}

