/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.CfnDBInstanceProps;
import software.amazon.awscdk.services.rds.DatabaseInstanceBase;
import software.amazon.awscdk.services.rds.DatabaseInstanceReadReplicaProps;
import software.amazon.awscdk.services.rds.Endpoint;
import software.amazon.awscdk.services.rds.IDatabaseInstance;
import software.amazon.awscdk.services.rds.IOptionGroup;
import software.amazon.awscdk.services.rds.PerformanceInsightRetention;
import software.amazon.awscdk.services.rds.ProcessorFeatures;
import software.amazon.awscdk.services.rds.StorageType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_rds.DatabaseInstanceReadReplica")
public class DatabaseInstanceReadReplica
extends DatabaseInstanceBase
implements IDatabaseInstance {
    protected DatabaseInstanceReadReplica(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstanceReadReplica(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseInstanceReadReplica(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseInstanceReadReplicaProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected void setLogRetention() {
        this.jsiiCall("setLogRetention", NativeType.VOID, new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public String getDbInstanceEndpointAddress() {
        return (String)this.jsiiGet("dbInstanceEndpointAddress", String.class);
    }

    @Override
    @NotNull
    public String getDbInstanceEndpointPort() {
        return (String)this.jsiiGet("dbInstanceEndpointPort", String.class);
    }

    @Override
    @NotNull
    public Endpoint getInstanceEndpoint() {
        return (Endpoint)((Object)this.jsiiGet("instanceEndpoint", Endpoint.class));
    }

    @Override
    @NotNull
    public String getInstanceIdentifier() {
        return (String)this.jsiiGet("instanceIdentifier", String.class);
    }

    @NotNull
    protected InstanceType getInstanceType() {
        return (InstanceType)((Object)this.jsiiGet("instanceType", InstanceType.class));
    }

    @NotNull
    protected CfnDBInstanceProps getNewCfnProps() {
        return (CfnDBInstanceProps)this.jsiiGet("newCfnProps", CfnDBInstanceProps.class);
    }

    @NotNull
    public IVpc getVpc() {
        return (IVpc)this.jsiiGet("vpc", IVpc.class);
    }

    @Nullable
    protected SubnetSelection getVpcPlacement() {
        return (SubnetSelection)this.jsiiGet("vpcPlacement", SubnetSelection.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseInstanceReadReplica> {
        private final Construct scope;
        private final String id;
        private final DatabaseInstanceReadReplicaProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseInstanceReadReplicaProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        public Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.props.deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        public Builder instanceIdentifier(String instanceIdentifier) {
            this.props.instanceIdentifier(instanceIdentifier);
            return this;
        }

        public Builder iops(Number iops) {
            this.props.iops(iops);
            return this;
        }

        public Builder maxAllocatedStorage(Number maxAllocatedStorage) {
            this.props.maxAllocatedStorage(maxAllocatedStorage);
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.props.multiAz(multiAz);
            return this;
        }

        public Builder optionGroup(IOptionGroup optionGroup) {
            this.props.optionGroup(optionGroup);
            return this;
        }

        public Builder performanceInsightEncryptionKey(IKey performanceInsightEncryptionKey) {
            this.props.performanceInsightEncryptionKey(performanceInsightEncryptionKey);
            return this;
        }

        public Builder performanceInsightRetention(PerformanceInsightRetention performanceInsightRetention) {
            this.props.performanceInsightRetention(performanceInsightRetention);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder processorFeatures(ProcessorFeatures processorFeatures) {
            this.props.processorFeatures(processorFeatures);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.props.storageType(storageType);
            return this;
        }

        public Builder vpcPlacement(SubnetSelection vpcPlacement) {
            this.props.vpcPlacement(vpcPlacement);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder sourceDatabaseInstance(IDatabaseInstance sourceDatabaseInstance) {
            this.props.sourceDatabaseInstance(sourceDatabaseInstance);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        public DatabaseInstanceReadReplica build() {
            return new DatabaseInstanceReadReplica(this.scope, this.id, this.props.build());
        }
    }
}

