/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.DatabaseInstanceNewProps;
import software.amazon.awscdk.services.rds.DatabaseInstanceReadReplicaProps;
import software.amazon.awscdk.services.rds.IDatabaseInstance;
import software.amazon.awscdk.services.rds.IOptionGroup;
import software.amazon.awscdk.services.rds.PerformanceInsightRetention;
import software.amazon.awscdk.services.rds.ProcessorFeatures;
import software.amazon.awscdk.services.rds.StorageType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_rds.DatabaseInstanceReadReplicaProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseInstanceReadReplicaProps
extends JsiiSerializable,
DatabaseInstanceNewProps {
    @NotNull
    public InstanceType getInstanceType();

    @NotNull
    public IDatabaseInstance getSourceDatabaseInstance();

    @Nullable
    default public Boolean getStorageEncrypted() {
        return null;
    }

    @Nullable
    default public IKey getStorageEncryptionKey() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseInstanceReadReplicaProps> {
        private InstanceType instanceType;
        private IDatabaseInstance sourceDatabaseInstance;
        private Boolean storageEncrypted;
        private IKey storageEncryptionKey;
        private IVpc vpc;
        private Boolean autoMinorVersionUpgrade;
        private String availabilityZone;
        private Duration backupRetention;
        private List<String> cloudwatchLogsExports;
        private RetentionDays cloudwatchLogsRetention;
        private IRole cloudwatchLogsRetentionRole;
        private Boolean copyTagsToSnapshot;
        private Boolean deleteAutomatedBackups;
        private Boolean deletionProtection;
        private Boolean enablePerformanceInsights;
        private Boolean iamAuthentication;
        private String instanceIdentifier;
        private Number iops;
        private Number maxAllocatedStorage;
        private Duration monitoringInterval;
        private IRole monitoringRole;
        private Boolean multiAz;
        private IOptionGroup optionGroup;
        private IKey performanceInsightEncryptionKey;
        private PerformanceInsightRetention performanceInsightRetention;
        private Number port;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private ProcessorFeatures processorFeatures;
        private RemovalPolicy removalPolicy;
        private List<ISecurityGroup> securityGroups;
        private StorageType storageType;
        private SubnetSelection vpcPlacement;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder sourceDatabaseInstance(IDatabaseInstance sourceDatabaseInstance) {
            this.sourceDatabaseInstance = sourceDatabaseInstance;
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.storageEncryptionKey = storageEncryptionKey;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        public Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public Builder iops(Number iops) {
            this.iops = iops;
            return this;
        }

        public Builder maxAllocatedStorage(Number maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        public Builder optionGroup(IOptionGroup optionGroup) {
            this.optionGroup = optionGroup;
            return this;
        }

        public Builder performanceInsightEncryptionKey(IKey performanceInsightEncryptionKey) {
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            return this;
        }

        public Builder performanceInsightRetention(PerformanceInsightRetention performanceInsightRetention) {
            this.performanceInsightRetention = performanceInsightRetention;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder processorFeatures(ProcessorFeatures processorFeatures) {
            this.processorFeatures = processorFeatures;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder vpcPlacement(SubnetSelection vpcPlacement) {
            this.vpcPlacement = vpcPlacement;
            return this;
        }

        public DatabaseInstanceReadReplicaProps build() {
            return new Jsii.Proxy(this.instanceType, this.sourceDatabaseInstance, this.storageEncrypted, this.storageEncryptionKey, this.vpc, this.autoMinorVersionUpgrade, this.availabilityZone, this.backupRetention, this.cloudwatchLogsExports, this.cloudwatchLogsRetention, this.cloudwatchLogsRetentionRole, this.copyTagsToSnapshot, this.deleteAutomatedBackups, this.deletionProtection, this.enablePerformanceInsights, this.iamAuthentication, this.instanceIdentifier, this.iops, this.maxAllocatedStorage, this.monitoringInterval, this.monitoringRole, this.multiAz, this.optionGroup, this.performanceInsightEncryptionKey, this.performanceInsightRetention, this.port, this.preferredBackupWindow, this.preferredMaintenanceWindow, this.processorFeatures, this.removalPolicy, this.securityGroups, this.storageType, this.vpcPlacement, null);
        }
    }
}

