/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.stepfunctions.CfnStateMachine;
import software.amazon.awscdk.services.stepfunctions.CfnStateMachineProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine")
public class CfnStateMachine
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStateMachine.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnStateMachine(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStateMachine(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStateMachine(@NotNull Construct scope, @NotNull String id, @NotNull CfnStateMachineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrName() {
        return (String)this.jsiiGet("attrName", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public Object getDefinitionSubstitutions() {
        return this.jsiiGet("definitionSubstitutions", Object.class);
    }

    public void setDefinitionSubstitutions(@NotNull Object value) {
        this.jsiiSet("definitionSubstitutions", Objects.requireNonNull(value, "definitionSubstitutions is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    public void setRoleArn(@NotNull String value) {
        this.jsiiSet("roleArn", Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public Object getDefinitionS3Location() {
        return this.jsiiGet("definitionS3Location", Object.class);
    }

    public void setDefinitionS3Location(@Nullable S3LocationProperty value) {
        this.jsiiSet("definitionS3Location", value);
    }

    public void setDefinitionS3Location(@Nullable IResolvable value) {
        this.jsiiSet("definitionS3Location", value);
    }

    @Nullable
    public String getDefinitionString() {
        return (String)this.jsiiGet("definitionString", String.class);
    }

    public void setDefinitionString(@Nullable String value) {
        this.jsiiSet("definitionString", value);
    }

    @Nullable
    public Object getLoggingConfiguration() {
        return this.jsiiGet("loggingConfiguration", Object.class);
    }

    public void setLoggingConfiguration(@Nullable LoggingConfigurationProperty value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    public void setLoggingConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    @Nullable
    public String getStateMachineName() {
        return (String)this.jsiiGet("stateMachineName", String.class);
    }

    public void setStateMachineName(@Nullable String value) {
        this.jsiiSet("stateMachineName", value);
    }

    @Nullable
    public String getStateMachineType() {
        return (String)this.jsiiGet("stateMachineType", String.class);
    }

    public void setStateMachineType(@Nullable String value) {
        this.jsiiSet("stateMachineType", value);
    }

    @Nullable
    public Object getTracingConfiguration() {
        return this.jsiiGet("tracingConfiguration", Object.class);
    }

    public void setTracingConfiguration(@Nullable TracingConfigurationProperty value) {
        this.jsiiSet("tracingConfiguration", value);
    }

    public void setTracingConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("tracingConfiguration", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStateMachine> {
        private final Construct scope;
        private final String id;
        private final CfnStateMachineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnStateMachineProps.Builder();
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder definitionS3Location(S3LocationProperty definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        public Builder definitionS3Location(IResolvable definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        public Builder definitionString(String definitionString) {
            this.props.definitionString(definitionString);
            return this;
        }

        public Builder definitionSubstitutions(Object definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder loggingConfiguration(LoggingConfigurationProperty loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder loggingConfiguration(IResolvable loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder stateMachineName(String stateMachineName) {
            this.props.stateMachineName(stateMachineName);
            return this;
        }

        public Builder stateMachineType(String stateMachineType) {
            this.props.stateMachineType(stateMachineType);
            return this;
        }

        public Builder tags(List<TagsEntryProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder tracingConfiguration(TracingConfigurationProperty tracingConfiguration) {
            this.props.tracingConfiguration(tracingConfiguration);
            return this;
        }

        public Builder tracingConfiguration(IResolvable tracingConfiguration) {
            this.props.tracingConfiguration(tracingConfiguration);
            return this;
        }

        public CfnStateMachine build() {
            return new CfnStateMachine(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine.TracingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TracingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TracingConfigurationProperty> {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public TracingConfigurationProperty build() {
                return new Jsii.Proxy(this.enabled, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine.TagsEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagsEntryProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagsEntryProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagsEntryProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            private String bucket;
            private String key;
            private String version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.version, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinations() {
            return null;
        }

        @Nullable
        default public Object getIncludeExecutionData() {
            return null;
        }

        @Nullable
        default public String getLevel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            private Object destinations;
            private Object includeExecutionData;
            private String level;

            public Builder destinations(IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            public Builder destinations(List<Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Builder includeExecutionData(Boolean includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder includeExecutionData(IResolvable includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this.destinations, this.includeExecutionData, this.level, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine.LogDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogDestinationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchLogsLogGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogDestinationProperty> {
            private Object cloudWatchLogsLogGroup;

            public Builder cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            public Builder cloudWatchLogsLogGroup(IResolvable cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            public LogDestinationProperty build() {
                return new Jsii.Proxy(this.cloudWatchLogsLogGroup, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_stepfunctions.CfnStateMachine.CloudWatchLogsLogGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsLogGroupProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogGroupArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsLogGroupProperty> {
            private String logGroupArn;

            public Builder logGroupArn(String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            public CloudWatchLogsLogGroupProperty build() {
                return new Jsii.Proxy(this.logGroupArn, null);
            }
        }
    }
}

