/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.cloudassembly.schema.ArtifactManifest;
import software.amazon.awscdk.cloudassembly.schema.ArtifactType;
import software.amazon.awscdk.cloudassembly.schema.AssetManifestProperties;
import software.amazon.awscdk.cloudassembly.schema.AwsCloudFormationStackProperties;
import software.amazon.awscdk.cloudassembly.schema.MetadataEntry;
import software.amazon.awscdk.cloudassembly.schema.NestedCloudAssemblyProperties;
import software.amazon.awscdk.cloudassembly.schema.TreeArtifactProperties;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.cxapi.CloudArtifact;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.Environment;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk-experiment.cx_api.CloudFormationStackArtifact")
public class CloudFormationStackArtifact
extends CloudArtifact {
    protected CloudFormationStackArtifact(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackArtifact(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFormationStackArtifact(@NotNull CloudAssembly assembly, @NotNull String artifactId, @NotNull ArtifactManifest artifact) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assembly, "assembly is required"), Objects.requireNonNull(artifactId, "artifactId is required"), Objects.requireNonNull(artifact, "artifact is required")});
    }

    @NotNull
    public List<Object> getAssets() {
        return Collections.unmodifiableList((List)this.jsiiGet("assets", NativeType.listOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDisplayName() {
        return (String)this.jsiiGet("displayName", String.class);
    }

    @NotNull
    public Environment getEnvironment() {
        return (Environment)this.jsiiGet("environment", Environment.class);
    }

    @Deprecated
    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    @NotNull
    public String getOriginalName() {
        return (String)this.jsiiGet("originalName", String.class);
    }

    @NotNull
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("parameters", NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getStackName() {
        return (String)this.jsiiGet("stackName", String.class);
    }

    @NotNull
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("tags", NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Object getTemplate() {
        return this.jsiiGet("template", Object.class);
    }

    @NotNull
    public String getTemplateFile() {
        return (String)this.jsiiGet("templateFile", String.class);
    }

    @NotNull
    public String getTemplateFullPath() {
        return (String)this.jsiiGet("templateFullPath", String.class);
    }

    @Nullable
    public String getAssumeRoleArn() {
        return (String)this.jsiiGet("assumeRoleArn", String.class);
    }

    @Nullable
    public String getCloudFormationExecutionRoleArn() {
        return (String)this.jsiiGet("cloudFormationExecutionRoleArn", String.class);
    }

    @Nullable
    public Number getRequiresBootstrapStackVersion() {
        return (Number)this.jsiiGet("requiresBootstrapStackVersion", Number.class);
    }

    @Nullable
    public String getStackTemplateAssetObjectUrl() {
        return (String)this.jsiiGet("stackTemplateAssetObjectUrl", String.class);
    }

    @Nullable
    public Boolean getTerminationProtection() {
        return (Boolean)this.jsiiGet("terminationProtection", Boolean.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudFormationStackArtifact> {
        private final CloudAssembly assembly;
        private final String artifactId;
        private final ArtifactManifest.Builder artifact;

        public static Builder create(CloudAssembly assembly, String artifactId) {
            return new Builder(assembly, artifactId);
        }

        private Builder(CloudAssembly assembly, String artifactId) {
            this.assembly = assembly;
            this.artifactId = artifactId;
            this.artifact = new ArtifactManifest.Builder();
        }

        public Builder type(ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        public Builder environment(String environment) {
            this.artifact.environment(environment);
            return this;
        }

        public Builder metadata(Map<String, ? extends List<? extends MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        public Builder properties(AwsCloudFormationStackProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(AssetManifestProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(TreeArtifactProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(NestedCloudAssemblyProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public CloudFormationStackArtifact build() {
            return new CloudFormationStackArtifact(this.assembly, this.artifactId, this.artifact.build());
        }
    }
}

