/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnOutput;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Stage;
import software.amazon.awscdk.pipelines.AddStageOptions;
import software.amazon.awscdk.pipelines.CdkPipelineProps;
import software.amazon.awscdk.pipelines.CdkStage;
import software.amazon.awscdk.pipelines.StackOutput;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.IAction;
import software.amazon.awscdk.services.codepipeline.IStage;
import software.amazon.awscdk.services.codepipeline.Pipeline;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.pipelines.CdkPipeline")
public class CdkPipeline
extends Construct {
    protected CdkPipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CdkPipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CdkPipeline(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull CdkPipelineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public CdkStage addApplicationStage(@NotNull Stage appStage, @Nullable AddStageOptions options) {
        return (CdkStage)this.jsiiCall("addApplicationStage", CdkStage.class, new Object[]{Objects.requireNonNull(appStage, "appStage is required"), options});
    }

    @NotNull
    public CdkStage addApplicationStage(@NotNull Stage appStage) {
        return (CdkStage)this.jsiiCall("addApplicationStage", CdkStage.class, new Object[]{Objects.requireNonNull(appStage, "appStage is required")});
    }

    @NotNull
    public CdkStage addStage(@NotNull String stageName) {
        return (CdkStage)this.jsiiCall("addStage", CdkStage.class, new Object[]{Objects.requireNonNull(stageName, "stageName is required")});
    }

    @NotNull
    public StackOutput stackOutput(@NotNull CfnOutput cfnOutput) {
        return (StackOutput)((Object)this.jsiiCall("stackOutput", StackOutput.class, new Object[]{Objects.requireNonNull(cfnOutput, "cfnOutput is required")}));
    }

    @NotNull
    public IStage stage(@NotNull String stageName) {
        return (IStage)this.jsiiCall("stage", IStage.class, new Object[]{Objects.requireNonNull(stageName, "stageName is required")});
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public Pipeline getCodePipeline() {
        return (Pipeline)this.jsiiGet("codePipeline", Pipeline.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CdkPipeline> {
        private final software.constructs.Construct scope;
        private final String id;
        private final CdkPipelineProps.Builder props;

        public static Builder create(software.constructs.Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(software.constructs.Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CdkPipelineProps.Builder();
        }

        public Builder cloudAssemblyArtifact(Artifact cloudAssemblyArtifact) {
            this.props.cloudAssemblyArtifact(cloudAssemblyArtifact);
            return this;
        }

        public Builder cdkCliVersion(String cdkCliVersion) {
            this.props.cdkCliVersion(cdkCliVersion);
            return this;
        }

        public Builder codePipeline(Pipeline codePipeline) {
            this.props.codePipeline(codePipeline);
            return this;
        }

        public Builder crossAccountKeys(Boolean crossAccountKeys) {
            this.props.crossAccountKeys(crossAccountKeys);
            return this;
        }

        public Builder pipelineName(String pipelineName) {
            this.props.pipelineName(pipelineName);
            return this;
        }

        public Builder sourceAction(IAction sourceAction) {
            this.props.sourceAction(sourceAction);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder synthAction(IAction synthAction) {
            this.props.synthAction(synthAction);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public CdkPipeline build() {
            return new CdkPipeline(this.scope, this.id, this.props.build());
        }
    }
}

