/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.apigateway.ConnectionType;
import software.amazon.awscdk.services.apigateway.ContentHandling;
import software.amazon.awscdk.services.apigateway.IVpcLink;
import software.amazon.awscdk.services.apigateway.IntegrationOptions;
import software.amazon.awscdk.services.apigateway.IntegrationResponse;
import software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions;
import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_apigateway.LambdaIntegrationOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface LambdaIntegrationOptions
extends JsiiSerializable,
IntegrationOptions {
    @Nullable
    default public Boolean getAllowTestInvoke() {
        return null;
    }

    @Nullable
    default public Boolean getProxy() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaIntegrationOptions> {
        private Boolean allowTestInvoke;
        private Boolean proxy;
        private List<String> cacheKeyParameters;
        private String cacheNamespace;
        private ConnectionType connectionType;
        private ContentHandling contentHandling;
        private Boolean credentialsPassthrough;
        private IRole credentialsRole;
        private List<IntegrationResponse> integrationResponses;
        private PassthroughBehavior passthroughBehavior;
        private Map<String, String> requestParameters;
        private Map<String, String> requestTemplates;
        private IVpcLink vpcLink;

        public Builder allowTestInvoke(Boolean allowTestInvoke) {
            this.allowTestInvoke = allowTestInvoke;
            return this;
        }

        public Builder proxy(Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
            this.cacheKeyParameters = cacheKeyParameters;
            return this;
        }

        public Builder cacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        public Builder connectionType(ConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder contentHandling(ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder credentialsPassthrough(Boolean credentialsPassthrough) {
            this.credentialsPassthrough = credentialsPassthrough;
            return this;
        }

        public Builder credentialsRole(IRole credentialsRole) {
            this.credentialsRole = credentialsRole;
            return this;
        }

        public Builder integrationResponses(List<? extends IntegrationResponse> integrationResponses) {
            this.integrationResponses = integrationResponses;
            return this;
        }

        public Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        public Builder vpcLink(IVpcLink vpcLink) {
            this.vpcLink = vpcLink;
            return this;
        }

        public LambdaIntegrationOptions build() {
            return new Jsii.Proxy(this.allowTestInvoke, this.proxy, this.cacheKeyParameters, this.cacheNamespace, this.connectionType, this.contentHandling, this.credentialsPassthrough, this.credentialsRole, this.integrationResponses, this.passthroughBehavior, this.requestParameters, this.requestTemplates, this.vpcLink, null);
        }
    }
}

