/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigatewayv2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apigatewayv2.AddRoutesOptions;
import software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions;
import software.amazon.awscdk.services.apigatewayv2.DefaultDomainMappingOptions;
import software.amazon.awscdk.services.apigatewayv2.HttpApiProps;
import software.amazon.awscdk.services.apigatewayv2.HttpRoute;
import software.amazon.awscdk.services.apigatewayv2.HttpStage;
import software.amazon.awscdk.services.apigatewayv2.HttpStageOptions;
import software.amazon.awscdk.services.apigatewayv2.IHttpApi;
import software.amazon.awscdk.services.apigatewayv2.IHttpRouteIntegration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_apigatewayv2.HttpApi")
public class HttpApi
extends Resource
implements IHttpApi {
    protected HttpApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HttpApi(@NotNull Construct scope, @NotNull String id, @Nullable HttpApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public HttpApi(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IHttpApi fromApiId(@NotNull Construct scope, @NotNull String id, @NotNull String httpApiId) {
        return (IHttpApi)JsiiObject.jsiiStaticCall(HttpApi.class, (String)"fromApiId", IHttpApi.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(httpApiId, "httpApiId is required")});
    }

    @NotNull
    public List<HttpRoute> addRoutes(@NotNull AddRoutesOptions options) {
        return Collections.unmodifiableList((List)this.jsiiCall("addRoutes", NativeType.listOf((NativeType)NativeType.forClass(HttpRoute.class)), new Object[]{Objects.requireNonNull(options, "options is required")}));
    }

    @NotNull
    public HttpStage addStage(@NotNull String id, @NotNull HttpStageOptions options) {
        return (HttpStage)this.jsiiCall("addStage", HttpStage.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public String getHttpApiId() {
        return (String)this.jsiiGet("httpApiId", String.class);
    }

    @Override
    @Nullable
    public HttpStage getDefaultStage() {
        return (HttpStage)this.jsiiGet("defaultStage", HttpStage.class);
    }

    @Nullable
    public String getUrl() {
        return (String)this.jsiiGet("url", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpApi> {
        private final Construct scope;
        private final String id;
        private HttpApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder apiName(String apiName) {
            this.props().apiName(apiName);
            return this;
        }

        public Builder corsPreflight(CorsPreflightOptions corsPreflight) {
            this.props().corsPreflight(corsPreflight);
            return this;
        }

        public Builder createDefaultStage(Boolean createDefaultStage) {
            this.props().createDefaultStage(createDefaultStage);
            return this;
        }

        public Builder defaultDomainMapping(DefaultDomainMappingOptions defaultDomainMapping) {
            this.props().defaultDomainMapping(defaultDomainMapping);
            return this;
        }

        public Builder defaultIntegration(IHttpRouteIntegration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        public HttpApi build() {
            return new HttpApi(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private HttpApiProps.Builder props() {
            if (this.props == null) {
                this.props = new HttpApiProps.Builder();
            }
            return this.props;
        }
    }
}

