/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appmesh;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.appmesh.IMesh;
import software.amazon.awscdk.services.appmesh.IVirtualRouter;
import software.amazon.awscdk.services.appmesh.RouteBaseProps;
import software.amazon.awscdk.services.appmesh.RouteProps;
import software.amazon.awscdk.services.appmesh.RouteType;
import software.amazon.awscdk.services.appmesh.WeightedTargetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appmesh.RouteProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface RouteProps
extends JsiiSerializable,
RouteBaseProps {
    @NotNull
    public IMesh getMesh();

    @NotNull
    public IVirtualRouter getVirtualRouter();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<RouteProps> {
        private IMesh mesh;
        private IVirtualRouter virtualRouter;
        private List<WeightedTargetProps> routeTargets;
        private String prefix;
        private String routeName;
        private RouteType routeType;

        public Builder mesh(IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        public Builder virtualRouter(IVirtualRouter virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        public Builder routeTargets(List<? extends WeightedTargetProps> routeTargets) {
            this.routeTargets = routeTargets;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public Builder routeType(RouteType routeType) {
            this.routeType = routeType;
            return this;
        }

        public RouteProps build() {
            return new Jsii.Proxy(this.mesh, this.virtualRouter, this.routeTargets, this.prefix, this.routeName, this.routeType, null);
        }
    }
}

