/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.appsync.CfnDataSource;
import software.amazon.awscdk.services.appsync.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDataSourceArn() {
        return (String)this.jsiiGet("attrDataSourceArn", String.class);
    }

    @NotNull
    public String getAttrName() {
        return (String)this.jsiiGet("attrName", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApiId() {
        return (String)this.jsiiGet("apiId", String.class);
    }

    public void setApiId(@NotNull String value) {
        this.jsiiSet("apiId", Objects.requireNonNull(value, "apiId is required"));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getType() {
        return (String)this.jsiiGet("type", String.class);
    }

    public void setType(@NotNull String value) {
        this.jsiiSet("type", Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getDynamoDbConfig() {
        return this.jsiiGet("dynamoDbConfig", Object.class);
    }

    public void setDynamoDbConfig(@Nullable DynamoDBConfigProperty value) {
        this.jsiiSet("dynamoDbConfig", value);
    }

    public void setDynamoDbConfig(@Nullable IResolvable value) {
        this.jsiiSet("dynamoDbConfig", value);
    }

    @Nullable
    public Object getElasticsearchConfig() {
        return this.jsiiGet("elasticsearchConfig", Object.class);
    }

    public void setElasticsearchConfig(@Nullable ElasticsearchConfigProperty value) {
        this.jsiiSet("elasticsearchConfig", value);
    }

    public void setElasticsearchConfig(@Nullable IResolvable value) {
        this.jsiiSet("elasticsearchConfig", value);
    }

    @Nullable
    public Object getHttpConfig() {
        return this.jsiiGet("httpConfig", Object.class);
    }

    public void setHttpConfig(@Nullable HttpConfigProperty value) {
        this.jsiiSet("httpConfig", value);
    }

    public void setHttpConfig(@Nullable IResolvable value) {
        this.jsiiSet("httpConfig", value);
    }

    @Nullable
    public Object getLambdaConfig() {
        return this.jsiiGet("lambdaConfig", Object.class);
    }

    public void setLambdaConfig(@Nullable LambdaConfigProperty value) {
        this.jsiiSet("lambdaConfig", value);
    }

    public void setLambdaConfig(@Nullable IResolvable value) {
        this.jsiiSet("lambdaConfig", value);
    }

    @Nullable
    public Object getRelationalDatabaseConfig() {
        return this.jsiiGet("relationalDatabaseConfig", Object.class);
    }

    public void setRelationalDatabaseConfig(@Nullable RelationalDatabaseConfigProperty value) {
        this.jsiiSet("relationalDatabaseConfig", value);
    }

    public void setRelationalDatabaseConfig(@Nullable IResolvable value) {
        this.jsiiSet("relationalDatabaseConfig", value);
    }

    @Nullable
    public String getServiceRoleArn() {
        return (String)this.jsiiGet("serviceRoleArn", String.class);
    }

    public void setServiceRoleArn(@Nullable String value) {
        this.jsiiSet("serviceRoleArn", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder apiId(String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder dynamoDbConfig(DynamoDBConfigProperty dynamoDbConfig) {
            this.props.dynamoDbConfig(dynamoDbConfig);
            return this;
        }

        public Builder dynamoDbConfig(IResolvable dynamoDbConfig) {
            this.props.dynamoDbConfig(dynamoDbConfig);
            return this;
        }

        public Builder elasticsearchConfig(ElasticsearchConfigProperty elasticsearchConfig) {
            this.props.elasticsearchConfig(elasticsearchConfig);
            return this;
        }

        public Builder elasticsearchConfig(IResolvable elasticsearchConfig) {
            this.props.elasticsearchConfig(elasticsearchConfig);
            return this;
        }

        public Builder httpConfig(HttpConfigProperty httpConfig) {
            this.props.httpConfig(httpConfig);
            return this;
        }

        public Builder httpConfig(IResolvable httpConfig) {
            this.props.httpConfig(httpConfig);
            return this;
        }

        public Builder lambdaConfig(LambdaConfigProperty lambdaConfig) {
            this.props.lambdaConfig(lambdaConfig);
            return this;
        }

        public Builder lambdaConfig(IResolvable lambdaConfig) {
            this.props.lambdaConfig(lambdaConfig);
            return this;
        }

        public Builder relationalDatabaseConfig(RelationalDatabaseConfigProperty relationalDatabaseConfig) {
            this.props.relationalDatabaseConfig(relationalDatabaseConfig);
            return this;
        }

        public Builder relationalDatabaseConfig(IResolvable relationalDatabaseConfig) {
            this.props.relationalDatabaseConfig(relationalDatabaseConfig);
            return this;
        }

        public Builder serviceRoleArn(String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.RelationalDatabaseConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RelationalDatabaseConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getRelationalDatabaseSourceType();

        @Nullable
        default public Object getRdsHttpEndpointConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RelationalDatabaseConfigProperty> {
            private String relationalDatabaseSourceType;
            private Object rdsHttpEndpointConfig;

            public Builder relationalDatabaseSourceType(String relationalDatabaseSourceType) {
                this.relationalDatabaseSourceType = relationalDatabaseSourceType;
                return this;
            }

            public Builder rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty rdsHttpEndpointConfig) {
                this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
                return this;
            }

            public Builder rdsHttpEndpointConfig(IResolvable rdsHttpEndpointConfig) {
                this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
                return this;
            }

            public RelationalDatabaseConfigProperty build() {
                return new Jsii.Proxy(this.relationalDatabaseSourceType, this.rdsHttpEndpointConfig, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.RdsHttpEndpointConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RdsHttpEndpointConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getAwsSecretStoreArn();

        @NotNull
        public String getDbClusterIdentifier();

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getSchema() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RdsHttpEndpointConfigProperty> {
            private String awsRegion;
            private String awsSecretStoreArn;
            private String dbClusterIdentifier;
            private String databaseName;
            private String schema;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder awsSecretStoreArn(String awsSecretStoreArn) {
                this.awsSecretStoreArn = awsSecretStoreArn;
                return this;
            }

            public Builder dbClusterIdentifier(String dbClusterIdentifier) {
                this.dbClusterIdentifier = dbClusterIdentifier;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder schema(String schema) {
                this.schema = schema;
                return this;
            }

            public RdsHttpEndpointConfigProperty build() {
                return new Jsii.Proxy(this.awsRegion, this.awsSecretStoreArn, this.dbClusterIdentifier, this.databaseName, this.schema, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.LambdaConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getLambdaFunctionArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaConfigProperty> {
            private String lambdaFunctionArn;

            public Builder lambdaFunctionArn(String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            public LambdaConfigProperty build() {
                return new Jsii.Proxy(this.lambdaFunctionArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.HttpConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpoint();

        @Nullable
        default public Object getAuthorizationConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpConfigProperty> {
            private String endpoint;
            private Object authorizationConfig;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder authorizationConfig(AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder authorizationConfig(IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public HttpConfigProperty build() {
                return new Jsii.Proxy(this.endpoint, this.authorizationConfig, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.ElasticsearchConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getEndpoint();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchConfigProperty> {
            private String awsRegion;
            private String endpoint;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public ElasticsearchConfigProperty build() {
                return new Jsii.Proxy(this.awsRegion, this.endpoint, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.DynamoDBConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getTableName();

        @Nullable
        default public Object getDeltaSyncConfig() {
            return null;
        }

        @Nullable
        default public Object getUseCallerCredentials() {
            return null;
        }

        @Nullable
        default public Object getVersioned() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBConfigProperty> {
            private String awsRegion;
            private String tableName;
            private Object deltaSyncConfig;
            private Object useCallerCredentials;
            private Object versioned;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder deltaSyncConfig(DeltaSyncConfigProperty deltaSyncConfig) {
                this.deltaSyncConfig = deltaSyncConfig;
                return this;
            }

            public Builder deltaSyncConfig(IResolvable deltaSyncConfig) {
                this.deltaSyncConfig = deltaSyncConfig;
                return this;
            }

            public Builder useCallerCredentials(Boolean useCallerCredentials) {
                this.useCallerCredentials = useCallerCredentials;
                return this;
            }

            public Builder useCallerCredentials(IResolvable useCallerCredentials) {
                this.useCallerCredentials = useCallerCredentials;
                return this;
            }

            public Builder versioned(Boolean versioned) {
                this.versioned = versioned;
                return this;
            }

            public Builder versioned(IResolvable versioned) {
                this.versioned = versioned;
                return this;
            }

            public DynamoDBConfigProperty build() {
                return new Jsii.Proxy(this.awsRegion, this.tableName, this.deltaSyncConfig, this.useCallerCredentials, this.versioned, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.DeltaSyncConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeltaSyncConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getBaseTableTtl();

        @NotNull
        public String getDeltaSyncTableName();

        @NotNull
        public String getDeltaSyncTableTtl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeltaSyncConfigProperty> {
            private String baseTableTtl;
            private String deltaSyncTableName;
            private String deltaSyncTableTtl;

            public Builder baseTableTtl(String baseTableTtl) {
                this.baseTableTtl = baseTableTtl;
                return this;
            }

            public Builder deltaSyncTableName(String deltaSyncTableName) {
                this.deltaSyncTableName = deltaSyncTableName;
                return this;
            }

            public Builder deltaSyncTableTtl(String deltaSyncTableTtl) {
                this.deltaSyncTableTtl = deltaSyncTableTtl;
                return this;
            }

            public DeltaSyncConfigProperty build() {
                return new Jsii.Proxy(this.baseTableTtl, this.deltaSyncTableName, this.deltaSyncTableTtl, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.AwsIamConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsIamConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSigningRegion() {
            return null;
        }

        @Nullable
        default public String getSigningServiceName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsIamConfigProperty> {
            private String signingRegion;
            private String signingServiceName;

            public Builder signingRegion(String signingRegion) {
                this.signingRegion = signingRegion;
                return this;
            }

            public Builder signingServiceName(String signingServiceName) {
                this.signingServiceName = signingServiceName;
                return this;
            }

            public AwsIamConfigProperty build() {
                return new Jsii.Proxy(this.signingRegion, this.signingServiceName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.CfnDataSource.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthorizationType();

        @Nullable
        default public Object getAwsIamConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            private String authorizationType;
            private Object awsIamConfig;

            public Builder authorizationType(String authorizationType) {
                this.authorizationType = authorizationType;
                return this;
            }

            public Builder awsIamConfig(AwsIamConfigProperty awsIamConfig) {
                this.awsIamConfig = awsIamConfig;
                return this;
            }

            public Builder awsIamConfig(IResolvable awsIamConfig) {
                this.awsIamConfig = awsIamConfig;
                return this;
            }

            public AuthorizationConfigProperty build() {
                return new Jsii.Proxy(this.authorizationType, this.awsIamConfig, null);
            }
        }
    }
}

