/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.services.appsync.AuthorizationConfig;
import software.amazon.awscdk.services.appsync.AuthorizationType;
import software.amazon.awscdk.services.appsync.GraphqlApiAttributes;
import software.amazon.awscdk.services.appsync.GraphqlApiBase;
import software.amazon.awscdk.services.appsync.GraphqlApiProps;
import software.amazon.awscdk.services.appsync.IGraphqlApi;
import software.amazon.awscdk.services.appsync.IIntermediateType;
import software.amazon.awscdk.services.appsync.IamResource;
import software.amazon.awscdk.services.appsync.LogConfig;
import software.amazon.awscdk.services.appsync.ObjectType;
import software.amazon.awscdk.services.appsync.ResolvableField;
import software.amazon.awscdk.services.appsync.Schema;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.GraphqlApi")
public class GraphqlApi
extends GraphqlApiBase {
    protected GraphqlApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphqlApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GraphqlApi(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IGraphqlApi fromGraphqlApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiAttributes attrs) {
        return (IGraphqlApi)JsiiObject.jsiiStaticCall(GraphqlApi.class, (String)"fromGraphqlApiAttributes", IGraphqlApi.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public ObjectType addMutation(@NotNull String fieldName, @NotNull ResolvableField field) {
        return (ObjectType)this.jsiiCall("addMutation", ObjectType.class, new Object[]{Objects.requireNonNull(fieldName, "fieldName is required"), Objects.requireNonNull(field, "field is required")});
    }

    @NotNull
    public ObjectType addQuery(@NotNull String fieldName, @NotNull ResolvableField field) {
        return (ObjectType)this.jsiiCall("addQuery", ObjectType.class, new Object[]{Objects.requireNonNull(fieldName, "fieldName is required"), Objects.requireNonNull(field, "field is required")});
    }

    @Override
    @NotNull
    public Boolean addSchemaDependency(@NotNull CfnResource construct) {
        return (Boolean)this.jsiiCall("addSchemaDependency", Boolean.class, new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    @NotNull
    public ObjectType addSubscription(@NotNull String fieldName, @NotNull ResolvableField field) {
        return (ObjectType)this.jsiiCall("addSubscription", ObjectType.class, new Object[]{Objects.requireNonNull(fieldName, "fieldName is required"), Objects.requireNonNull(field, "field is required")});
    }

    public void addToSchema(@NotNull String addition, @Nullable String delimiter) {
        this.jsiiCall("addToSchema", NativeType.VOID, new Object[]{Objects.requireNonNull(addition, "addition is required"), delimiter});
    }

    public void addToSchema(@NotNull String addition) {
        this.jsiiCall("addToSchema", NativeType.VOID, new Object[]{Objects.requireNonNull(addition, "addition is required")});
    }

    @NotNull
    public IIntermediateType addType(@NotNull IIntermediateType type) {
        return (IIntermediateType)this.jsiiCall("addType", IIntermediateType.class, new Object[]{Objects.requireNonNull(type, "type is required")});
    }

    @NotNull
    public Grant grant(@NotNull IGrantable grantee, @NotNull IamResource resources, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(resources, "resources is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantMutation(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)this.jsiiCall("grantMutation", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantQuery(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)this.jsiiCall("grantQuery", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantSubscription(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)this.jsiiCall("grantSubscription", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)this.jsiiGet("apiId", String.class);
    }

    @Override
    @NotNull
    public String getArn() {
        return (String)this.jsiiGet("arn", String.class);
    }

    @NotNull
    public String getGraphqlUrl() {
        return (String)this.jsiiGet("graphqlUrl", String.class);
    }

    @NotNull
    public List<AuthorizationType> getModes() {
        return Collections.unmodifiableList((List)this.jsiiGet("modes", NativeType.listOf((NativeType)NativeType.forClass(AuthorizationType.class))));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    @NotNull
    public Schema getSchema() {
        return (Schema)((Object)this.jsiiGet("schema", Schema.class));
    }

    @Nullable
    public String getApiKey() {
        return (String)this.jsiiGet("apiKey", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GraphqlApi> {
        private final Construct scope;
        private final String id;
        private final GraphqlApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new GraphqlApiProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder authorizationConfig(AuthorizationConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        public Builder logConfig(LogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        public Builder schema(Schema schema) {
            this.props.schema(schema);
            return this;
        }

        public Builder xrayEnabled(Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        public GraphqlApi build() {
            return new GraphqlApi(this.scope, this.id, this.props.build());
        }
    }
}

