/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.AlarmBase;
import software.amazon.awscdk.services.cloudwatch.AlarmProps;
import software.amazon.awscdk.services.cloudwatch.ComparisonOperator;
import software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.TreatMissingData;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.Alarm")
public class Alarm
extends AlarmBase {
    protected Alarm(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Alarm(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Alarm(@NotNull Construct scope, @NotNull String id, @NotNull AlarmProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAlarm fromAlarmArn(@NotNull Construct scope, @NotNull String id, @NotNull String alarmArn) {
        return (IAlarm)JsiiObject.jsiiStaticCall(Alarm.class, (String)"fromAlarmArn", IAlarm.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(alarmArn, "alarmArn is required")});
    }

    @NotNull
    public HorizontalAnnotation toAnnotation() {
        return (HorizontalAnnotation)this.jsiiCall("toAnnotation", HorizontalAnnotation.class, new Object[0]);
    }

    @Override
    @NotNull
    public String getAlarmArn() {
        return (String)this.jsiiGet("alarmArn", String.class);
    }

    @Override
    @NotNull
    public String getAlarmName() {
        return (String)this.jsiiGet("alarmName", String.class);
    }

    @NotNull
    public IMetric getMetric() {
        return (IMetric)this.jsiiGet("metric", IMetric.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Alarm> {
        private final Construct scope;
        private final String id;
        private final AlarmProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AlarmProps.Builder();
        }

        public Builder evaluationPeriods(Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        public Builder threshold(Number threshold) {
            this.props.threshold(threshold);
            return this;
        }

        public Builder actionsEnabled(Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        public Builder alarmDescription(String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        public Builder alarmName(String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        public Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.props.comparisonOperator(comparisonOperator);
            return this;
        }

        public Builder datapointsToAlarm(Number datapointsToAlarm) {
            this.props.datapointsToAlarm(datapointsToAlarm);
            return this;
        }

        public Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.props.evaluateLowSampleCountPercentile(evaluateLowSampleCountPercentile);
            return this;
        }

        @Deprecated
        public Builder period(Duration period) {
            this.props.period(period);
            return this;
        }

        @Deprecated
        public Builder statistic(String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        public Builder treatMissingData(TreatMissingData treatMissingData) {
            this.props.treatMissingData(treatMissingData);
            return this;
        }

        public Builder metric(IMetric metric) {
            this.props.metric(metric);
            return this;
        }

        public Alarm build() {
            return new Alarm(this.scope, this.id, this.props.build());
        }
    }
}

