/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.ResourceProps;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.cloudwatch.IAlarmAction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.AlarmBase")
public abstract class AlarmBase
extends Resource
implements IAlarm {
    protected AlarmBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlarmBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected AlarmBase(@NotNull Construct scope, @NotNull String id, @Nullable ResourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    protected AlarmBase(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addAlarmAction(IAlarmAction ... actions) {
        this.jsiiCall("addAlarmAction", NativeType.VOID, Arrays.stream(actions).toArray(Object[]::new));
    }

    public void addInsufficientDataAction(IAlarmAction ... actions) {
        this.jsiiCall("addInsufficientDataAction", NativeType.VOID, Arrays.stream(actions).toArray(Object[]::new));
    }

    public void addOkAction(IAlarmAction ... actions) {
        this.jsiiCall("addOkAction", NativeType.VOID, Arrays.stream(actions).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public String renderAlarmRule() {
        return (String)this.jsiiCall("renderAlarmRule", String.class, new Object[0]);
    }

    @Override
    @NotNull
    public abstract String getAlarmArn();

    @Override
    @NotNull
    public abstract String getAlarmName();

    @Nullable
    protected List<String> getAlarmActionArns() {
        return Optional.ofNullable((List)this.jsiiGet("alarmActionArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    protected void setAlarmActionArns(@Nullable List<String> value) {
        this.jsiiSet("alarmActionArns", value);
    }

    @Nullable
    protected List<String> getInsufficientDataActionArns() {
        return Optional.ofNullable((List)this.jsiiGet("insufficientDataActionArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    protected void setInsufficientDataActionArns(@Nullable List<String> value) {
        this.jsiiSet("insufficientDataActionArns", value);
    }

    @Nullable
    protected List<String> getOkActionArns() {
        return Optional.ofNullable((List)this.jsiiGet("okActionArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    protected void setOkActionArns(@Nullable List<String> value) {
        this.jsiiSet("okActionArns", value);
    }
}

