/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codecommit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.codecommit.CfnRepository;
import software.amazon.awscdk.services.codecommit.CfnRepositoryProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codecommit.CfnRepository")
public class CfnRepository
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRepository.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnRepository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRepository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id, @NotNull CfnRepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrCloneUrlHttp() {
        return (String)this.jsiiGet("attrCloneUrlHttp", String.class);
    }

    @NotNull
    public String getAttrCloneUrlSsh() {
        return (String)this.jsiiGet("attrCloneUrlSsh", String.class);
    }

    @NotNull
    public String getAttrName() {
        return (String)this.jsiiGet("attrName", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getRepositoryName() {
        return (String)this.jsiiGet("repositoryName", String.class);
    }

    public void setRepositoryName(@NotNull String value) {
        this.jsiiSet("repositoryName", Objects.requireNonNull(value, "repositoryName is required"));
    }

    @Nullable
    public Object getCode() {
        return this.jsiiGet("code", Object.class);
    }

    public void setCode(@Nullable CodeProperty value) {
        this.jsiiSet("code", value);
    }

    public void setCode(@Nullable IResolvable value) {
        this.jsiiSet("code", value);
    }

    @Nullable
    public String getRepositoryDescription() {
        return (String)this.jsiiGet("repositoryDescription", String.class);
    }

    public void setRepositoryDescription(@Nullable String value) {
        this.jsiiSet("repositoryDescription", value);
    }

    @Nullable
    public Object getTriggers() {
        return this.jsiiGet("triggers", Object.class);
    }

    public void setTriggers(@Nullable IResolvable value) {
        this.jsiiSet("triggers", value);
    }

    public void setTriggers(@Nullable List<Object> value) {
        this.jsiiSet("triggers", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnRepository> {
        private final Construct scope;
        private final String id;
        private final CfnRepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnRepositoryProps.Builder();
        }

        public Builder repositoryName(String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        public Builder code(CodeProperty code) {
            this.props.code(code);
            return this;
        }

        public Builder code(IResolvable code) {
            this.props.code(code);
            return this;
        }

        public Builder repositoryDescription(String repositoryDescription) {
            this.props.repositoryDescription(repositoryDescription);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder triggers(IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public Builder triggers(List<? extends Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public CfnRepository build() {
            return new CfnRepository(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codecommit.CfnRepository.S3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3Property
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getObjectVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3Property> {
            private String bucket;
            private String key;
            private String objectVersion;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder objectVersion(String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            public S3Property build() {
                return new Jsii.Proxy(this.bucket, this.key, this.objectVersion, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codecommit.CfnRepository.RepositoryTriggerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepositoryTriggerProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestinationArn();

        @NotNull
        public List<String> getEvents();

        @NotNull
        public String getName();

        @Nullable
        default public List<String> getBranches() {
            return null;
        }

        @Nullable
        default public String getCustomData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepositoryTriggerProperty> {
            private String destinationArn;
            private List<String> events;
            private String name;
            private List<String> branches;
            private String customData;

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder branches(List<String> branches) {
                this.branches = branches;
                return this;
            }

            public Builder customData(String customData) {
                this.customData = customData;
                return this;
            }

            public RepositoryTriggerProperty build() {
                return new Jsii.Proxy(this.destinationArn, this.events, this.name, this.branches, this.customData, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codecommit.CfnRepository.CodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3();

        @Nullable
        default public String getBranchName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeProperty> {
            private Object s3;
            private String branchName;

            public Builder s3(S3Property s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder branchName(String branchName) {
                this.branchName = branchName;
                return this;
            }

            public CodeProperty build() {
                return new Jsii.Proxy(this.s3, this.branchName, null);
            }
        }
    }
}

