/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.codepipeline.CrossRegionSupport;
import software.amazon.awscdk.services.codepipeline.IPipeline;
import software.amazon.awscdk.services.codepipeline.IStage;
import software.amazon.awscdk.services.codepipeline.PipelineProps;
import software.amazon.awscdk.services.codepipeline.StageOptions;
import software.amazon.awscdk.services.codepipeline.StageProps;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.Pipeline")
public class Pipeline
extends Resource
implements IPipeline {
    protected Pipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Pipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Pipeline(@NotNull Construct scope, @NotNull String id, @Nullable PipelineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Pipeline(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IPipeline fromPipelineArn(@NotNull Construct scope, @NotNull String id, @NotNull String pipelineArn) {
        return (IPipeline)JsiiObject.jsiiStaticCall(Pipeline.class, (String)"fromPipelineArn", IPipeline.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(pipelineArn, "pipelineArn is required")});
    }

    @NotNull
    public IStage addStage(@NotNull StageOptions props) {
        return (IStage)this.jsiiCall("addStage", IStage.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id) {
        return (Rule)this.jsiiCall("onStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public IStage stage(@NotNull String stageName) {
        return (IStage)this.jsiiCall("stage", IStage.class, new Object[]{Objects.requireNonNull(stageName, "stageName is required")});
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public IBucket getArtifactBucket() {
        return (IBucket)this.jsiiGet("artifactBucket", IBucket.class);
    }

    @NotNull
    public Map<String, CrossRegionSupport> getCrossRegionSupport() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("crossRegionSupport", NativeType.mapOf((NativeType)NativeType.forClass(CrossRegionSupport.class))));
    }

    @Override
    @NotNull
    public String getPipelineArn() {
        return (String)this.jsiiGet("pipelineArn", String.class);
    }

    @Override
    @NotNull
    public String getPipelineName() {
        return (String)this.jsiiGet("pipelineName", String.class);
    }

    @NotNull
    public String getPipelineVersion() {
        return (String)this.jsiiGet("pipelineVersion", String.class);
    }

    @NotNull
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    @NotNull
    public Number getStageCount() {
        return (Number)this.jsiiGet("stageCount", Number.class);
    }

    @NotNull
    public List<IStage> getStages() {
        return Collections.unmodifiableList((List)this.jsiiGet("stages", NativeType.listOf((NativeType)NativeType.forClass(IStage.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Pipeline> {
        private final Construct scope;
        private final String id;
        private PipelineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder artifactBucket(IBucket artifactBucket) {
            this.props().artifactBucket(artifactBucket);
            return this;
        }

        public Builder crossAccountKeys(Boolean crossAccountKeys) {
            this.props().crossAccountKeys(crossAccountKeys);
            return this;
        }

        public Builder crossRegionReplicationBuckets(Map<String, ? extends IBucket> crossRegionReplicationBuckets) {
            this.props().crossRegionReplicationBuckets(crossRegionReplicationBuckets);
            return this;
        }

        public Builder pipelineName(String pipelineName) {
            this.props().pipelineName(pipelineName);
            return this;
        }

        public Builder restartExecutionOnUpdate(Boolean restartExecutionOnUpdate) {
            this.props().restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder stages(List<? extends StageProps> stages) {
            this.props().stages(stages);
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private PipelineProps.Builder props() {
            if (this.props == null) {
                this.props = new PipelineProps.Builder();
            }
            return this.props;
        }
    }
}

