/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ecs.CfnService;
import software.amazon.awscdk.services.ecs.CfnServiceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService")
public class CfnService
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnService.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnService(@NotNull Construct scope, @NotNull String id, @Nullable CfnServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnService(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrName() {
        return (String)this.jsiiGet("attrName", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @Nullable
    public Object getCapacityProviderStrategy() {
        return this.jsiiGet("capacityProviderStrategy", Object.class);
    }

    public void setCapacityProviderStrategy(@Nullable IResolvable value) {
        this.jsiiSet("capacityProviderStrategy", value);
    }

    public void setCapacityProviderStrategy(@Nullable List<Object> value) {
        this.jsiiSet("capacityProviderStrategy", value);
    }

    @Nullable
    public String getCluster() {
        return (String)this.jsiiGet("cluster", String.class);
    }

    public void setCluster(@Nullable String value) {
        this.jsiiSet("cluster", value);
    }

    @Nullable
    public Object getDeploymentConfiguration() {
        return this.jsiiGet("deploymentConfiguration", Object.class);
    }

    public void setDeploymentConfiguration(@Nullable DeploymentConfigurationProperty value) {
        this.jsiiSet("deploymentConfiguration", value);
    }

    public void setDeploymentConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("deploymentConfiguration", value);
    }

    @Nullable
    public Object getDeploymentController() {
        return this.jsiiGet("deploymentController", Object.class);
    }

    public void setDeploymentController(@Nullable DeploymentControllerProperty value) {
        this.jsiiSet("deploymentController", value);
    }

    public void setDeploymentController(@Nullable IResolvable value) {
        this.jsiiSet("deploymentController", value);
    }

    @Nullable
    public Number getDesiredCount() {
        return (Number)this.jsiiGet("desiredCount", Number.class);
    }

    public void setDesiredCount(@Nullable Number value) {
        this.jsiiSet("desiredCount", value);
    }

    @Nullable
    public Object getEnableEcsManagedTags() {
        return this.jsiiGet("enableEcsManagedTags", Object.class);
    }

    public void setEnableEcsManagedTags(@Nullable Boolean value) {
        this.jsiiSet("enableEcsManagedTags", value);
    }

    public void setEnableEcsManagedTags(@Nullable IResolvable value) {
        this.jsiiSet("enableEcsManagedTags", value);
    }

    @Nullable
    public Number getHealthCheckGracePeriodSeconds() {
        return (Number)this.jsiiGet("healthCheckGracePeriodSeconds", Number.class);
    }

    public void setHealthCheckGracePeriodSeconds(@Nullable Number value) {
        this.jsiiSet("healthCheckGracePeriodSeconds", value);
    }

    @Nullable
    public String getLaunchType() {
        return (String)this.jsiiGet("launchType", String.class);
    }

    public void setLaunchType(@Nullable String value) {
        this.jsiiSet("launchType", value);
    }

    @Nullable
    public Object getLoadBalancers() {
        return this.jsiiGet("loadBalancers", Object.class);
    }

    public void setLoadBalancers(@Nullable IResolvable value) {
        this.jsiiSet("loadBalancers", value);
    }

    public void setLoadBalancers(@Nullable List<Object> value) {
        this.jsiiSet("loadBalancers", value);
    }

    @Nullable
    public Object getNetworkConfiguration() {
        return this.jsiiGet("networkConfiguration", Object.class);
    }

    public void setNetworkConfiguration(@Nullable NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }

    public void setNetworkConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("networkConfiguration", value);
    }

    @Nullable
    public Object getPlacementConstraints() {
        return this.jsiiGet("placementConstraints", Object.class);
    }

    public void setPlacementConstraints(@Nullable IResolvable value) {
        this.jsiiSet("placementConstraints", value);
    }

    public void setPlacementConstraints(@Nullable List<Object> value) {
        this.jsiiSet("placementConstraints", value);
    }

    @Nullable
    public Object getPlacementStrategies() {
        return this.jsiiGet("placementStrategies", Object.class);
    }

    public void setPlacementStrategies(@Nullable IResolvable value) {
        this.jsiiSet("placementStrategies", value);
    }

    public void setPlacementStrategies(@Nullable List<Object> value) {
        this.jsiiSet("placementStrategies", value);
    }

    @Nullable
    public String getPlatformVersion() {
        return (String)this.jsiiGet("platformVersion", String.class);
    }

    public void setPlatformVersion(@Nullable String value) {
        this.jsiiSet("platformVersion", value);
    }

    @Nullable
    public String getPropagateTags() {
        return (String)this.jsiiGet("propagateTags", String.class);
    }

    public void setPropagateTags(@Nullable String value) {
        this.jsiiSet("propagateTags", value);
    }

    @Nullable
    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(@Nullable String value) {
        this.jsiiSet("role", value);
    }

    @Nullable
    public String getSchedulingStrategy() {
        return (String)this.jsiiGet("schedulingStrategy", String.class);
    }

    public void setSchedulingStrategy(@Nullable String value) {
        this.jsiiSet("schedulingStrategy", value);
    }

    @Nullable
    public String getServiceArn() {
        return (String)this.jsiiGet("serviceArn", String.class);
    }

    public void setServiceArn(@Nullable String value) {
        this.jsiiSet("serviceArn", value);
    }

    @Nullable
    public String getServiceName() {
        return (String)this.jsiiGet("serviceName", String.class);
    }

    public void setServiceName(@Nullable String value) {
        this.jsiiSet("serviceName", value);
    }

    @Nullable
    public Object getServiceRegistries() {
        return this.jsiiGet("serviceRegistries", Object.class);
    }

    public void setServiceRegistries(@Nullable IResolvable value) {
        this.jsiiSet("serviceRegistries", value);
    }

    public void setServiceRegistries(@Nullable List<Object> value) {
        this.jsiiSet("serviceRegistries", value);
    }

    @Nullable
    public String getTaskDefinition() {
        return (String)this.jsiiGet("taskDefinition", String.class);
    }

    public void setTaskDefinition(@Nullable String value) {
        this.jsiiSet("taskDefinition", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnService> {
        private final Construct scope;
        private final String id;
        private CfnServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder capacityProviderStrategy(IResolvable capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }

        public Builder capacityProviderStrategy(List<? extends Object> capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }

        public Builder cluster(String cluster) {
            this.props().cluster(cluster);
            return this;
        }

        public Builder deploymentConfiguration(DeploymentConfigurationProperty deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        public Builder deploymentConfiguration(IResolvable deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        public Builder deploymentController(DeploymentControllerProperty deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder deploymentController(IResolvable deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableEcsManagedTags(IResolvable enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder healthCheckGracePeriodSeconds(Number healthCheckGracePeriodSeconds) {
            this.props().healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds);
            return this;
        }

        public Builder launchType(String launchType) {
            this.props().launchType(launchType);
            return this;
        }

        public Builder loadBalancers(IResolvable loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        public Builder loadBalancers(List<? extends Object> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder networkConfiguration(IResolvable networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder placementConstraints(IResolvable placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementConstraints(List<? extends Object> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(IResolvable placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        public Builder placementStrategies(List<? extends Object> placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        public Builder propagateTags(String propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public Builder role(String role) {
            this.props().role(role);
            return this;
        }

        public Builder schedulingStrategy(String schedulingStrategy) {
            this.props().schedulingStrategy(schedulingStrategy);
            return this;
        }

        public Builder serviceArn(String serviceArn) {
            this.props().serviceArn(serviceArn);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        public Builder serviceRegistries(IResolvable serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }

        public Builder serviceRegistries(List<? extends Object> serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder taskDefinition(String taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        public CfnService build() {
            return new CfnService(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServiceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.ServiceRegistryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceRegistryProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getRegistryArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceRegistryProperty> {
            private String containerName;
            private Number containerPort;
            private Number port;
            private String registryArn;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder registryArn(String registryArn) {
                this.registryArn = registryArn;
                return this;
            }

            public ServiceRegistryProperty build() {
                return new Jsii.Proxy(this.containerName, this.containerPort, this.port, this.registryArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementStrategyProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            private String type;
            private String field;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder field(String field) {
                this.field = field;
                return this;
            }

            public PlacementStrategyProperty build() {
                return new Jsii.Proxy(this.type, this.field, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementConstraintProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            private String type;
            private String expression;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public PlacementConstraintProperty build() {
                return new Jsii.Proxy(this.type, this.expression, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsvpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            private Object awsvpcConfiguration;

            public Builder awsvpcConfiguration(AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            public Builder awsvpcConfiguration(IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this.awsvpcConfiguration, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.LoadBalancerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadBalancerProperty
    extends JsiiSerializable {
        @NotNull
        public Number getContainerPort();

        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public String getLoadBalancerName() {
            return null;
        }

        @Nullable
        default public String getTargetGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadBalancerProperty> {
            private Number containerPort;
            private String containerName;
            private String loadBalancerName;
            private String targetGroupArn;

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder loadBalancerName(String loadBalancerName) {
                this.loadBalancerName = loadBalancerName;
                return this;
            }

            public Builder targetGroupArn(String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            public LoadBalancerProperty build() {
                return new Jsii.Proxy(this.containerPort, this.containerName, this.loadBalancerName, this.targetGroupArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.DeploymentControllerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentControllerProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentControllerProperty> {
            private String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DeploymentControllerProperty build() {
                return new Jsii.Proxy(this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.DeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaximumPercent() {
            return null;
        }

        @Nullable
        default public Number getMinimumHealthyPercent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentConfigurationProperty> {
            private Number maximumPercent;
            private Number minimumHealthyPercent;

            public Builder maximumPercent(Number maximumPercent) {
                this.maximumPercent = maximumPercent;
                return this;
            }

            public Builder minimumHealthyPercent(Number minimumHealthyPercent) {
                this.minimumHealthyPercent = minimumHealthyPercent;
                return this;
            }

            public DeploymentConfigurationProperty build() {
                return new Jsii.Proxy(this.maximumPercent, this.minimumHealthyPercent, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityProviderStrategyItemProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBase() {
            return null;
        }

        @Nullable
        default public String getCapacityProvider() {
            return null;
        }

        @Nullable
        default public Number getWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            private Number base;
            private String capacityProvider;
            private Number weight;

            public Builder base(Number base) {
                this.base = base;
                return this;
            }

            public Builder capacityProvider(String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            public Builder weight(Number weight) {
                this.weight = weight;
                return this;
            }

            public CapacityProviderStrategyItemProperty build() {
                return new Jsii.Proxy(this.base, this.capacityProvider, this.weight, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.CfnService.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSubnets();

        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            private List<String> subnets;
            private String assignPublicIp;
            private List<String> securityGroups;

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public AwsVpcConfigurationProperty build() {
                return new Jsii.Proxy(this.subnets, this.assignPublicIp, this.securityGroups, null);
            }
        }
    }
}

