/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.BaseServiceOptions;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2ServiceProps;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.Ec2ServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface Ec2ServiceProps
extends JsiiSerializable,
BaseServiceOptions {
    @NotNull
    public TaskDefinition getTaskDefinition();

    @Nullable
    default public Boolean getAssignPublicIp() {
        return null;
    }

    @Nullable
    default public Boolean getDaemon() {
        return null;
    }

    @Nullable
    default public List<PlacementConstraint> getPlacementConstraints() {
        return null;
    }

    @Nullable
    default public List<PlacementStrategy> getPlacementStrategies() {
        return null;
    }

    @Deprecated
    @Nullable
    default public PropagatedTagSource getPropagateTaskTagsFrom() {
        return null;
    }

    @Deprecated
    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Ec2ServiceProps> {
        private TaskDefinition taskDefinition;
        private Boolean assignPublicIp;
        private Boolean daemon;
        private List<PlacementConstraint> placementConstraints;
        private List<PlacementStrategy> placementStrategies;
        private PropagatedTagSource propagateTaskTagsFrom;
        private ISecurityGroup securityGroup;
        private List<ISecurityGroup> securityGroups;
        private SubnetSelection vpcSubnets;
        private ICluster cluster;
        private CloudMapOptions cloudMapOptions;
        private DeploymentController deploymentController;
        private Number desiredCount;
        private Boolean enableEcsManagedTags;
        private Duration healthCheckGracePeriod;
        private Number maxHealthyPercent;
        private Number minHealthyPercent;
        private PropagatedTagSource propagateTags;
        private String serviceName;

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public Builder daemon(Boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.placementStrategies = placementStrategies;
            return this;
        }

        @Deprecated
        public Builder propagateTaskTagsFrom(PropagatedTagSource propagateTaskTagsFrom) {
            this.propagateTaskTagsFrom = propagateTaskTagsFrom;
            return this;
        }

        @Deprecated
        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Ec2ServiceProps build() {
            return new Jsii.Proxy(this.taskDefinition, this.assignPublicIp, this.daemon, this.placementConstraints, this.placementStrategies, this.propagateTaskTagsFrom, this.securityGroup, this.securityGroups, this.vpcSubnets, this.cluster, this.cloudMapOptions, this.deploymentController, this.desiredCount, this.enableEcsManagedTags, this.healthCheckGracePeriod, this.maxHealthyPercent, this.minHealthyPercent, this.propagateTags, this.serviceName, null);
        }
    }
}

