/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ecs.ContainerDefinitionOptions;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.FirelensConfig;
import software.amazon.awscdk.services.ecs.FirelensLogRouterDefinitionOptions;
import software.amazon.awscdk.services.ecs.HealthCheck;
import software.amazon.awscdk.services.ecs.LinuxParameters;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.FirelensLogRouterDefinitionOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface FirelensLogRouterDefinitionOptions
extends JsiiSerializable,
ContainerDefinitionOptions {
    @NotNull
    public FirelensConfig getFirelensConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirelensLogRouterDefinitionOptions> {
        private FirelensConfig firelensConfig;
        private ContainerImage image;
        private List<String> command;
        private Number cpu;
        private Boolean disableNetworking;
        private List<String> dnsSearchDomains;
        private List<String> dnsServers;
        private Map<String, String> dockerLabels;
        private List<String> dockerSecurityOptions;
        private List<String> entryPoint;
        private Map<String, String> environment;
        private Boolean essential;
        private Map<String, String> extraHosts;
        private Number gpuCount;
        private HealthCheck healthCheck;
        private String hostname;
        private LinuxParameters linuxParameters;
        private LogDriver logging;
        private Number memoryLimitMiB;
        private Number memoryReservationMiB;
        private Boolean privileged;
        private Boolean readonlyRootFilesystem;
        private Map<String, Secret> secrets;
        private Duration startTimeout;
        private Duration stopTimeout;
        private String user;
        private String workingDirectory;

        public Builder firelensConfig(FirelensConfig firelensConfig) {
            this.firelensConfig = firelensConfig;
            return this;
        }

        public Builder image(ContainerImage image) {
            this.image = image;
            return this;
        }

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder disableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
            this.dnsSearchDomains = dnsSearchDomains;
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public Builder dockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = dockerLabels;
            return this;
        }

        public Builder dockerSecurityOptions(List<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = dockerSecurityOptions;
            return this;
        }

        public Builder entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public Builder extraHosts(Map<String, String> extraHosts) {
            this.extraHosts = extraHosts;
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.logging = logging;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.secrets = secrets;
            return this;
        }

        public Builder startTimeout(Duration startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public Builder stopTimeout(Duration stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public FirelensLogRouterDefinitionOptions build() {
            return new Jsii.Proxy(this.firelensConfig, this.image, this.command, this.cpu, this.disableNetworking, this.dnsSearchDomains, this.dnsServers, this.dockerLabels, this.dockerSecurityOptions, this.entryPoint, this.environment, this.essential, this.extraHosts, this.gpuCount, this.healthCheck, this.hostname, this.linuxParameters, this.logging, this.memoryLimitMiB, this.memoryReservationMiB, this.privileged, this.readonlyRootFilesystem, this.secrets, this.startTimeout, this.stopTimeout, this.user, this.workingDirectory, null);
        }
    }
}

