/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CommonAutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration;
import software.amazon.awscdk.services.autoscaling.UpdateType;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.AutoScalingGroupCapacityOptions;
import software.amazon.awscdk.services.eks.BootstrapOptions;
import software.amazon.awscdk.services.eks.MachineImageType;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.AutoScalingGroupCapacityOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface AutoScalingGroupCapacityOptions
extends JsiiSerializable,
CommonAutoScalingGroupProps {
    @NotNull
    public InstanceType getInstanceType();

    @Nullable
    default public Boolean getBootstrapEnabled() {
        return null;
    }

    @Nullable
    default public BootstrapOptions getBootstrapOptions() {
        return null;
    }

    @Nullable
    default public MachineImageType getMachineImageType() {
        return null;
    }

    @Nullable
    default public Boolean getMapRole() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AutoScalingGroupCapacityOptions> {
        private InstanceType instanceType;
        private Boolean bootstrapEnabled;
        private BootstrapOptions bootstrapOptions;
        private MachineImageType machineImageType;
        private Boolean mapRole;
        private Boolean allowAllOutbound;
        private Boolean associatePublicIpAddress;
        private String autoScalingGroupName;
        private List<BlockDevice> blockDevices;
        private Duration cooldown;
        private Number desiredCapacity;
        private List<GroupMetrics> groupMetrics;
        private HealthCheck healthCheck;
        private Boolean ignoreUnmodifiedSizeProperties;
        private Monitoring instanceMonitoring;
        private String keyName;
        private Number maxCapacity;
        private Duration maxInstanceLifetime;
        private Number minCapacity;
        private List<NotificationConfiguration> notifications;
        private ITopic notificationsTopic;
        private Number replacingUpdateMinSuccessfulInstancesPercent;
        private Number resourceSignalCount;
        private Duration resourceSignalTimeout;
        private RollingUpdateConfiguration rollingUpdateConfiguration;
        private String spotPrice;
        private UpdateType updateType;
        private SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder bootstrapEnabled(Boolean bootstrapEnabled) {
            this.bootstrapEnabled = bootstrapEnabled;
            return this;
        }

        public Builder bootstrapOptions(BootstrapOptions bootstrapOptions) {
            this.bootstrapOptions = bootstrapOptions;
            return this;
        }

        public Builder machineImageType(MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        public Builder mapRole(Boolean mapRole) {
            this.mapRole = mapRole;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder groupMetrics(List<? extends GroupMetrics> groupMetrics) {
            this.groupMetrics = groupMetrics;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public Builder notifications(List<? extends NotificationConfiguration> notifications) {
            this.notifications = notifications;
            return this;
        }

        @Deprecated
        public Builder notificationsTopic(ITopic notificationsTopic) {
            this.notificationsTopic = notificationsTopic;
            return this;
        }

        public Builder replacingUpdateMinSuccessfulInstancesPercent(Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.replacingUpdateMinSuccessfulInstancesPercent = replacingUpdateMinSuccessfulInstancesPercent;
            return this;
        }

        public Builder resourceSignalCount(Number resourceSignalCount) {
            this.resourceSignalCount = resourceSignalCount;
            return this;
        }

        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        public Builder rollingUpdateConfiguration(RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.rollingUpdateConfiguration = rollingUpdateConfiguration;
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public AutoScalingGroupCapacityOptions build() {
            return new Jsii.Proxy(this.instanceType, this.bootstrapEnabled, this.bootstrapOptions, this.machineImageType, this.mapRole, this.allowAllOutbound, this.associatePublicIpAddress, this.autoScalingGroupName, this.blockDevices, this.cooldown, this.desiredCapacity, this.groupMetrics, this.healthCheck, this.ignoreUnmodifiedSizeProperties, this.instanceMonitoring, this.keyName, this.maxCapacity, this.maxInstanceLifetime, this.minCapacity, this.notifications, this.notificationsTopic, this.replacingUpdateMinSuccessfulInstancesPercent, this.resourceSignalCount, this.resourceSignalTimeout, this.rollingUpdateConfiguration, this.spotPrice, this.updateType, this.vpcSubnets, null);
        }
    }
}

