/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.eks.CfnCluster;
import software.amazon.awscdk.services.eks.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrCertificateAuthorityData() {
        return (String)this.jsiiGet("attrCertificateAuthorityData", String.class);
    }

    @NotNull
    public String getAttrClusterSecurityGroupId() {
        return (String)this.jsiiGet("attrClusterSecurityGroupId", String.class);
    }

    @NotNull
    public String getAttrEncryptionConfigKeyArn() {
        return (String)this.jsiiGet("attrEncryptionConfigKeyArn", String.class);
    }

    @NotNull
    public String getAttrEndpoint() {
        return (String)this.jsiiGet("attrEndpoint", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getResourcesVpcConfig() {
        return this.jsiiGet("resourcesVpcConfig", Object.class);
    }

    public void setResourcesVpcConfig(@NotNull ResourcesVpcConfigProperty value) {
        this.jsiiSet("resourcesVpcConfig", Objects.requireNonNull(value, "resourcesVpcConfig is required"));
    }

    public void setResourcesVpcConfig(@NotNull IResolvable value) {
        this.jsiiSet("resourcesVpcConfig", Objects.requireNonNull(value, "resourcesVpcConfig is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    public void setRoleArn(@NotNull String value) {
        this.jsiiSet("roleArn", Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public Object getEncryptionConfig() {
        return this.jsiiGet("encryptionConfig", Object.class);
    }

    public void setEncryptionConfig(@Nullable IResolvable value) {
        this.jsiiSet("encryptionConfig", value);
    }

    public void setEncryptionConfig(@Nullable List<Object> value) {
        this.jsiiSet("encryptionConfig", value);
    }

    @Nullable
    public Object getKubernetesNetworkConfig() {
        return this.jsiiGet("kubernetesNetworkConfig", Object.class);
    }

    public void setKubernetesNetworkConfig(@Nullable KubernetesNetworkConfigProperty value) {
        this.jsiiSet("kubernetesNetworkConfig", value);
    }

    public void setKubernetesNetworkConfig(@Nullable IResolvable value) {
        this.jsiiSet("kubernetesNetworkConfig", value);
    }

    @Nullable
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@Nullable String value) {
        this.jsiiSet("name", value);
    }

    @Nullable
    public String getVersion() {
        return (String)this.jsiiGet("version", String.class);
    }

    public void setVersion(@Nullable String value) {
        this.jsiiSet("version", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder resourcesVpcConfig(ResourcesVpcConfigProperty resourcesVpcConfig) {
            this.props.resourcesVpcConfig(resourcesVpcConfig);
            return this;
        }

        public Builder resourcesVpcConfig(IResolvable resourcesVpcConfig) {
            this.props.resourcesVpcConfig(resourcesVpcConfig);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder encryptionConfig(IResolvable encryptionConfig) {
            this.props.encryptionConfig(encryptionConfig);
            return this;
        }

        public Builder encryptionConfig(List<? extends Object> encryptionConfig) {
            this.props.encryptionConfig(encryptionConfig);
            return this;
        }

        public Builder kubernetesNetworkConfig(KubernetesNetworkConfigProperty kubernetesNetworkConfig) {
            this.props.kubernetesNetworkConfig(kubernetesNetworkConfig);
            return this;
        }

        public Builder kubernetesNetworkConfig(IResolvable kubernetesNetworkConfig) {
            this.props.kubernetesNetworkConfig(kubernetesNetworkConfig);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder version(String version) {
            this.props.version(version);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.CfnCluster.ResourcesVpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourcesVpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSubnetIds();

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourcesVpcConfigProperty> {
            private List<String> subnetIds;
            private List<String> securityGroupIds;

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public ResourcesVpcConfigProperty build() {
                return new Jsii.Proxy(this.subnetIds, this.securityGroupIds, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.CfnCluster.ProviderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProviderProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProviderProperty> {
            private String keyArn;

            public Builder keyArn(String keyArn) {
                this.keyArn = keyArn;
                return this;
            }

            public ProviderProperty build() {
                return new Jsii.Proxy(this.keyArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.CfnCluster.KubernetesNetworkConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KubernetesNetworkConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getServiceIpv4Cidr() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KubernetesNetworkConfigProperty> {
            private String serviceIpv4Cidr;

            public Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
                this.serviceIpv4Cidr = serviceIpv4Cidr;
                return this;
            }

            public KubernetesNetworkConfigProperty build() {
                return new Jsii.Proxy(this.serviceIpv4Cidr, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.CfnCluster.EncryptionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getProvider() {
            return null;
        }

        @Nullable
        default public List<String> getResources() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigProperty> {
            private Object provider;
            private List<String> resources;

            public Builder provider(ProviderProperty provider) {
                this.provider = provider;
                return this;
            }

            public Builder provider(IResolvable provider) {
                this.provider = provider;
                return this;
            }

            public Builder resources(List<String> resources) {
                this.resources = resources;
                return this;
            }

            public EncryptionConfigProperty build() {
                return new Jsii.Proxy(this.provider, this.resources, null);
            }
        }
    }
}

