/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.Cluster;
import software.amazon.awscdk.services.eks.CoreDnsComputeType;
import software.amazon.awscdk.services.eks.EndpointAccess;
import software.amazon.awscdk.services.eks.FargateClusterProps;
import software.amazon.awscdk.services.eks.FargateProfileOptions;
import software.amazon.awscdk.services.eks.KubernetesVersion;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.FargateCluster")
public class FargateCluster
extends Cluster {
    protected FargateCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FargateCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FargateCluster(@NotNull Construct scope, @NotNull String id, @NotNull FargateClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FargateCluster> {
        private final Construct scope;
        private final String id;
        private final FargateClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new FargateClusterProps.Builder();
        }

        public Builder version(KubernetesVersion version) {
            this.props.version(version);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.props.outputClusterName(outputClusterName);
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.props.outputConfigCommand(outputConfigCommand);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(List<? extends SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder coreDnsComputeType(CoreDnsComputeType coreDnsComputeType) {
            this.props.coreDnsComputeType(coreDnsComputeType);
            return this;
        }

        public Builder endpointAccess(EndpointAccess endpointAccess) {
            this.props.endpointAccess(endpointAccess);
            return this;
        }

        public Builder kubectlEnvironment(Map<String, String> kubectlEnvironment) {
            this.props.kubectlEnvironment(kubectlEnvironment);
            return this;
        }

        public Builder kubectlLayer(ILayerVersion kubectlLayer) {
            this.props.kubectlLayer(kubectlLayer);
            return this;
        }

        public Builder mastersRole(IRole mastersRole) {
            this.props.mastersRole(mastersRole);
            return this;
        }

        public Builder outputMastersRoleArn(Boolean outputMastersRoleArn) {
            this.props.outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        public Builder defaultProfile(FargateProfileOptions defaultProfile) {
            this.props.defaultProfile(defaultProfile);
            return this;
        }

        public FargateCluster build() {
            return new FargateCluster(this.scope, this.id, this.props.build());
        }
    }
}

