/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancing;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancing.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.ListenerPort;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_elasticloadbalancing.LoadBalancer")
public class LoadBalancer
extends Resource
implements IConnectable {
    protected LoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LoadBalancer(@NotNull Construct scope, @NotNull String id, @NotNull LoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public ListenerPort addListener(@NotNull LoadBalancerListener listener) {
        return (ListenerPort)this.jsiiCall("addListener", ListenerPort.class, new Object[]{Objects.requireNonNull(listener, "listener is required")});
    }

    public void addTarget(@NotNull ILoadBalancerTarget target) {
        this.jsiiCall("addTarget", NativeType.VOID, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @NotNull
    public List<ListenerPort> getListenerPorts() {
        return Collections.unmodifiableList((List)this.jsiiGet("listenerPorts", NativeType.listOf((NativeType)NativeType.forClass(ListenerPort.class))));
    }

    @NotNull
    public String getLoadBalancerCanonicalHostedZoneName() {
        return (String)this.jsiiGet("loadBalancerCanonicalHostedZoneName", String.class);
    }

    @NotNull
    public String getLoadBalancerCanonicalHostedZoneNameId() {
        return (String)this.jsiiGet("loadBalancerCanonicalHostedZoneNameId", String.class);
    }

    @NotNull
    public String getLoadBalancerDnsName() {
        return (String)this.jsiiGet("loadBalancerDnsName", String.class);
    }

    @NotNull
    public String getLoadBalancerName() {
        return (String)this.jsiiGet("loadBalancerName", String.class);
    }

    @NotNull
    public String getLoadBalancerSourceSecurityGroupGroupName() {
        return (String)this.jsiiGet("loadBalancerSourceSecurityGroupGroupName", String.class);
    }

    @NotNull
    public String getLoadBalancerSourceSecurityGroupOwnerAlias() {
        return (String)this.jsiiGet("loadBalancerSourceSecurityGroupOwnerAlias", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LoadBalancer> {
        private final Construct scope;
        private final String id;
        private final LoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LoadBalancerProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder crossZone(Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder listeners(List<? extends LoadBalancerListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder targets(List<? extends ILoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

