/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_elasticloadbalancingv2.ApplicationTargetGroupProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ApplicationTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public ApplicationProtocol getProtocol() {
        return null;
    }

    @Nullable
    default public Duration getSlowStart() {
        return null;
    }

    @Nullable
    default public Duration getStickinessCookieDuration() {
        return null;
    }

    @Nullable
    default public List<IApplicationLoadBalancerTarget> getTargets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationTargetGroupProps> {
        private Number port;
        private ApplicationProtocol protocol;
        private Duration slowStart;
        private Duration stickinessCookieDuration;
        private List<IApplicationLoadBalancerTarget> targets;
        private Duration deregistrationDelay;
        private HealthCheck healthCheck;
        private String targetGroupName;
        private TargetType targetType;
        private IVpc vpc;

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder slowStart(Duration slowStart) {
            this.slowStart = slowStart;
            return this;
        }

        public Builder stickinessCookieDuration(Duration stickinessCookieDuration) {
            this.stickinessCookieDuration = stickinessCookieDuration;
            return this;
        }

        public Builder targets(List<? extends IApplicationLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ApplicationTargetGroupProps build() {
            return new Jsii.Proxy(this.port, this.protocol, this.slowStart, this.stickinessCookieDuration, this.targets, this.deregistrationDelay, this.healthCheck, this.targetGroupName, this.targetType, this.vpc, null);
        }
    }
}

