/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions;
import software.amazon.awscdk.services.elasticsearch.CapacityConfig;
import software.amazon.awscdk.services.elasticsearch.CognitoOptions;
import software.amazon.awscdk.services.elasticsearch.DomainAttributes;
import software.amazon.awscdk.services.elasticsearch.DomainProps;
import software.amazon.awscdk.services.elasticsearch.EbsOptions;
import software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion;
import software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions;
import software.amazon.awscdk.services.elasticsearch.IDomain;
import software.amazon.awscdk.services.elasticsearch.LoggingOptions;
import software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy;
import software.amazon.awscdk.services.elasticsearch.VpcOptions;
import software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_elasticsearch.Domain")
public class Domain
extends Resource
implements IDomain {
    protected Domain(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Domain(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Domain(@NotNull Construct scope, @NotNull String id, @NotNull DomainProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDomain fromDomainAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DomainAttributes attrs) {
        return (IDomain)JsiiObject.jsiiStaticCall(Domain.class, (String)"fromDomainAttributes", IDomain.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IDomain fromDomainEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull String domainEndpoint) {
        return (IDomain)JsiiObject.jsiiStaticCall(Domain.class, (String)"fromDomainEndpoint", IDomain.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(domainEndpoint, "domainEndpoint is required")});
    }

    @Override
    @NotNull
    public Grant grantIndexRead(@NotNull String index, @NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantIndexRead", Grant.class, new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantIndexReadWrite(@NotNull String index, @NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantIndexReadWrite", Grant.class, new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantIndexWrite(@NotNull String index, @NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantIndexWrite", Grant.class, new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantPathRead(@NotNull String path, @NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantPathRead", Grant.class, new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantPathReadWrite(@NotNull String path, @NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantPathReadWrite", Grant.class, new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantPathWrite(@NotNull String path, @NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantPathWrite", Grant.class, new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricAutomatedSnapshotFailure(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricAutomatedSnapshotFailure", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricAutomatedSnapshotFailure() {
        return (Metric)this.jsiiCall("metricAutomatedSnapshotFailure", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricClusterIndexWriteBlocked(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricClusterIndexWriteBlocked", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClusterIndexWriteBlocked() {
        return (Metric)this.jsiiCall("metricClusterIndexWriteBlocked", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricClusterStatusRed(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricClusterStatusRed", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClusterStatusRed() {
        return (Metric)this.jsiiCall("metricClusterStatusRed", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricClusterStatusYellow(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricClusterStatusYellow", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClusterStatusYellow() {
        return (Metric)this.jsiiCall("metricClusterStatusYellow", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricCPUUtilization(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricCPUUtilization", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricCPUUtilization() {
        return (Metric)this.jsiiCall("metricCPUUtilization", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricFreeStorageSpace(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricFreeStorageSpace", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricFreeStorageSpace() {
        return (Metric)this.jsiiCall("metricFreeStorageSpace", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIndexingLatency(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricIndexingLatency", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIndexingLatency() {
        return (Metric)this.jsiiCall("metricIndexingLatency", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricJVMMemoryPressure(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricJVMMemoryPressure", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricJVMMemoryPressure() {
        return (Metric)this.jsiiCall("metricJVMMemoryPressure", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricKMSKeyError(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricKMSKeyError", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricKMSKeyError() {
        return (Metric)this.jsiiCall("metricKMSKeyError", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricKMSKeyInaccessible(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricKMSKeyInaccessible", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricKMSKeyInaccessible() {
        return (Metric)this.jsiiCall("metricKMSKeyInaccessible", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricMasterCPUUtilization(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricMasterCPUUtilization", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricMasterCPUUtilization() {
        return (Metric)this.jsiiCall("metricMasterCPUUtilization", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricMasterJVMMemoryPressure(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricMasterJVMMemoryPressure", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricMasterJVMMemoryPressure() {
        return (Metric)this.jsiiCall("metricMasterJVMMemoryPressure", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNodes(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricNodes", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNodes() {
        return (Metric)this.jsiiCall("metricNodes", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSearchableDocuments(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricSearchableDocuments", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSearchableDocuments() {
        return (Metric)this.jsiiCall("metricSearchableDocuments", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSearchLatency(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricSearchLatency", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSearchLatency() {
        return (Metric)this.jsiiCall("metricSearchLatency", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public String getDomainArn() {
        return (String)this.jsiiGet("domainArn", String.class);
    }

    @Override
    @NotNull
    public String getDomainEndpoint() {
        return (String)this.jsiiGet("domainEndpoint", String.class);
    }

    @Override
    @NotNull
    public String getDomainName() {
        return (String)this.jsiiGet("domainName", String.class);
    }

    @Nullable
    public ILogGroup getAppLogGroup() {
        return (ILogGroup)this.jsiiGet("appLogGroup", ILogGroup.class);
    }

    @Nullable
    public SecretValue getMasterUserPassword() {
        return (SecretValue)this.jsiiGet("masterUserPassword", SecretValue.class);
    }

    @Nullable
    public ILogGroup getSlowIndexLogGroup() {
        return (ILogGroup)this.jsiiGet("slowIndexLogGroup", ILogGroup.class);
    }

    @Nullable
    public ILogGroup getSlowSearchLogGroup() {
        return (ILogGroup)this.jsiiGet("slowSearchLogGroup", ILogGroup.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Domain> {
        private final Construct scope;
        private final String id;
        private final DomainProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DomainProps.Builder();
        }

        public Builder version(ElasticsearchVersion version) {
            this.props.version(version);
            return this;
        }

        public Builder accessPolicies(List<? extends PolicyStatement> accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        public Builder advancedOptions(Map<String, String> advancedOptions) {
            this.props.advancedOptions(advancedOptions);
            return this;
        }

        public Builder automatedSnapshotStartHour(Number automatedSnapshotStartHour) {
            this.props.automatedSnapshotStartHour(automatedSnapshotStartHour);
            return this;
        }

        public Builder capacity(CapacityConfig capacity) {
            this.props.capacity(capacity);
            return this;
        }

        public Builder cognitoKibanaAuth(CognitoOptions cognitoKibanaAuth) {
            this.props.cognitoKibanaAuth(cognitoKibanaAuth);
            return this;
        }

        public Builder domainName(String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder ebs(EbsOptions ebs) {
            this.props.ebs(ebs);
            return this;
        }

        public Builder encryptionAtRest(EncryptionAtRestOptions encryptionAtRest) {
            this.props.encryptionAtRest(encryptionAtRest);
            return this;
        }

        public Builder enforceHttps(Boolean enforceHttps) {
            this.props.enforceHttps(enforceHttps);
            return this;
        }

        public Builder fineGrainedAccessControl(AdvancedSecurityOptions fineGrainedAccessControl) {
            this.props.fineGrainedAccessControl(fineGrainedAccessControl);
            return this;
        }

        public Builder logging(LoggingOptions logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder nodeToNodeEncryption(Boolean nodeToNodeEncryption) {
            this.props.nodeToNodeEncryption(nodeToNodeEncryption);
            return this;
        }

        public Builder tlsSecurityPolicy(TLSSecurityPolicy tlsSecurityPolicy) {
            this.props.tlsSecurityPolicy(tlsSecurityPolicy);
            return this;
        }

        public Builder useUnsignedBasicAuth(Boolean useUnsignedBasicAuth) {
            this.props.useUnsignedBasicAuth(useUnsignedBasicAuth);
            return this;
        }

        public Builder vpcOptions(VpcOptions vpcOptions) {
            this.props.vpcOptions(vpcOptions);
            return this;
        }

        public Builder zoneAwareness(ZoneAwarenessConfig zoneAwareness) {
            this.props.zoneAwareness(zoneAwareness);
            return this;
        }

        public Domain build() {
            return new Domain(this.scope, this.id, this.props.build());
        }
    }
}

