/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.glue.CfnCrawler;
import software.amazon.awscdk.services.glue.CfnCrawlerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler")
public class CfnCrawler
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCrawler.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnCrawler(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCrawler(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCrawler(@NotNull Construct scope, @NotNull String id, @NotNull CfnCrawlerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(@NotNull String value) {
        this.jsiiSet("role", Objects.requireNonNull(value, "role is required"));
    }

    @NotNull
    public Object getTargets() {
        return this.jsiiGet("targets", Object.class);
    }

    public void setTargets(@NotNull TargetsProperty value) {
        this.jsiiSet("targets", Objects.requireNonNull(value, "targets is required"));
    }

    public void setTargets(@NotNull IResolvable value) {
        this.jsiiSet("targets", Objects.requireNonNull(value, "targets is required"));
    }

    @Nullable
    public List<String> getClassifiers() {
        return Optional.ofNullable((List)this.jsiiGet("classifiers", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setClassifiers(@Nullable List<String> value) {
        this.jsiiSet("classifiers", value);
    }

    @Nullable
    public String getConfiguration() {
        return (String)this.jsiiGet("configuration", String.class);
    }

    public void setConfiguration(@Nullable String value) {
        this.jsiiSet("configuration", value);
    }

    @Nullable
    public String getCrawlerSecurityConfiguration() {
        return (String)this.jsiiGet("crawlerSecurityConfiguration", String.class);
    }

    public void setCrawlerSecurityConfiguration(@Nullable String value) {
        this.jsiiSet("crawlerSecurityConfiguration", value);
    }

    @Nullable
    public String getDatabaseName() {
        return (String)this.jsiiGet("databaseName", String.class);
    }

    public void setDatabaseName(@Nullable String value) {
        this.jsiiSet("databaseName", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@Nullable String value) {
        this.jsiiSet("name", value);
    }

    @Nullable
    public Object getSchedule() {
        return this.jsiiGet("schedule", Object.class);
    }

    public void setSchedule(@Nullable ScheduleProperty value) {
        this.jsiiSet("schedule", value);
    }

    public void setSchedule(@Nullable IResolvable value) {
        this.jsiiSet("schedule", value);
    }

    @Nullable
    public Object getSchemaChangePolicy() {
        return this.jsiiGet("schemaChangePolicy", Object.class);
    }

    public void setSchemaChangePolicy(@Nullable SchemaChangePolicyProperty value) {
        this.jsiiSet("schemaChangePolicy", value);
    }

    public void setSchemaChangePolicy(@Nullable IResolvable value) {
        this.jsiiSet("schemaChangePolicy", value);
    }

    @Nullable
    public String getTablePrefix() {
        return (String)this.jsiiGet("tablePrefix", String.class);
    }

    public void setTablePrefix(@Nullable String value) {
        this.jsiiSet("tablePrefix", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCrawler> {
        private final Construct scope;
        private final String id;
        private final CfnCrawlerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCrawlerProps.Builder();
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder targets(TargetsProperty targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder classifiers(List<String> classifiers) {
            this.props.classifiers(classifiers);
            return this;
        }

        public Builder configuration(String configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder crawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.props.crawlerSecurityConfiguration(crawlerSecurityConfiguration);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder schedule(ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schedule(IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schemaChangePolicy(SchemaChangePolicyProperty schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }

        public Builder schemaChangePolicy(IResolvable schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }

        public Builder tablePrefix(String tablePrefix) {
            this.props.tablePrefix(tablePrefix);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCrawler build() {
            return new CfnCrawler(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.TargetsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCatalogTargets() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbTargets() {
            return null;
        }

        @Nullable
        default public Object getJdbcTargets() {
            return null;
        }

        @Nullable
        default public Object getS3Targets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetsProperty> {
            private Object catalogTargets;
            private Object dynamoDbTargets;
            private Object jdbcTargets;
            private Object s3Targets;

            public Builder catalogTargets(IResolvable catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            public Builder catalogTargets(List<? extends Object> catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            public Builder dynamoDbTargets(IResolvable dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            public Builder dynamoDbTargets(List<? extends Object> dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            public Builder jdbcTargets(IResolvable jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            public Builder jdbcTargets(List<? extends Object> jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            public Builder s3Targets(IResolvable s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            public Builder s3Targets(List<? extends Object> s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            public TargetsProperty build() {
                return new Jsii.Proxy(this.catalogTargets, this.dynamoDbTargets, this.jdbcTargets, this.s3Targets, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.SchemaChangePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SchemaChangePolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeleteBehavior() {
            return null;
        }

        @Nullable
        default public String getUpdateBehavior() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SchemaChangePolicyProperty> {
            private String deleteBehavior;
            private String updateBehavior;

            public Builder deleteBehavior(String deleteBehavior) {
                this.deleteBehavior = deleteBehavior;
                return this;
            }

            public Builder updateBehavior(String updateBehavior) {
                this.updateBehavior = updateBehavior;
                return this;
            }

            public SchemaChangePolicyProperty build() {
                return new Jsii.Proxy(this.deleteBehavior, this.updateBehavior, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.ScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getScheduleExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleProperty> {
            private String scheduleExpression;

            public Builder scheduleExpression(String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            public ScheduleProperty build() {
                return new Jsii.Proxy(this.scheduleExpression, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.S3TargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3TargetProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getExclusions() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3TargetProperty> {
            private List<String> exclusions;
            private String path;

            public Builder exclusions(List<String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public S3TargetProperty build() {
                return new Jsii.Proxy(this.exclusions, this.path, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.JdbcTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JdbcTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public List<String> getExclusions() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JdbcTargetProperty> {
            private String connectionName;
            private List<String> exclusions;
            private String path;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder exclusions(List<String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public JdbcTargetProperty build() {
                return new Jsii.Proxy(this.connectionName, this.exclusions, this.path, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.DynamoDBTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBTargetProperty> {
            private String path;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public DynamoDBTargetProperty build() {
                return new Jsii.Proxy(this.path, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_glue.CfnCrawler.CatalogTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CatalogTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public List<String> getTables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CatalogTargetProperty> {
            private String databaseName;
            private List<String> tables;

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder tables(List<String> tables) {
                this.tables = tables;
                return this;
            }

            public CatalogTargetProperty build() {
                return new Jsii.Proxy(this.databaseName, this.tables, null);
            }
        }
    }
}

