/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kendra;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kendra.CfnDataSource;
import software.amazon.awscdk.services.kendra.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrId() {
        return (String)this.jsiiGet("attrId", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDataSourceConfiguration() {
        return this.jsiiGet("dataSourceConfiguration", Object.class);
    }

    public void setDataSourceConfiguration(@NotNull DataSourceConfigurationProperty value) {
        this.jsiiSet("dataSourceConfiguration", Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    public void setDataSourceConfiguration(@NotNull IResolvable value) {
        this.jsiiSet("dataSourceConfiguration", Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    @NotNull
    public String getIndexId() {
        return (String)this.jsiiGet("indexId", String.class);
    }

    public void setIndexId(@NotNull String value) {
        this.jsiiSet("indexId", Objects.requireNonNull(value, "indexId is required"));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    public void setRoleArn(@NotNull String value) {
        this.jsiiSet("roleArn", Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public String getType() {
        return (String)this.jsiiGet("type", String.class);
    }

    public void setType(@NotNull String value) {
        this.jsiiSet("type", Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getSchedule() {
        return (String)this.jsiiGet("schedule", String.class);
    }

    public void setSchedule(@Nullable String value) {
        this.jsiiSet("schedule", value);
    }

    @Nullable
    public TagListProperty getTags() {
        return (TagListProperty)this.jsiiGet("tags", TagListProperty.class);
    }

    public void setTags(@Nullable TagListProperty value) {
        this.jsiiSet("tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder dataSourceConfiguration(DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder dataSourceConfiguration(IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder indexId(String indexId) {
            this.props.indexId(indexId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder schedule(String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder tags(TagListProperty tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.TagListProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagListProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTagList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagListProperty> {
            private Object tagList;

            public Builder tagList(IResolvable tagList) {
                this.tagList = tagList;
                return this;
            }

            public Builder tagList(List<? extends Object> tagList) {
                this.tagList = tagList;
                return this;
            }

            public TagListProperty build() {
                return new Jsii.Proxy(this.tagList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SqlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqlConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getQueryIdentifiersEnclosingOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqlConfigurationProperty> {
            private String queryIdentifiersEnclosingOption;

            public Builder queryIdentifiersEnclosingOption(String queryIdentifiersEnclosingOption) {
                this.queryIdentifiersEnclosingOption = queryIdentifiersEnclosingOption;
                return this;
            }

            public SqlConfigurationProperty build() {
                return new Jsii.Proxy(this.queryIdentifiersEnclosingOption, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SharePointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharePointConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getSharePointVersion();

        @NotNull
        public List<String> getUrls();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getUseChangeLog() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharePointConfigurationProperty> {
            private String secretArn;
            private String sharePointVersion;
            private List<String> urls;
            private Object crawlAttachments;
            private String documentTitleFieldName;
            private Object exclusionPatterns;
            private Object fieldMappings;
            private Object inclusionPatterns;
            private Object useChangeLog;
            private Object vpcConfiguration;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder sharePointVersion(String sharePointVersion) {
                this.sharePointVersion = sharePointVersion;
                return this;
            }

            public Builder urls(List<String> urls) {
                this.urls = urls;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder exclusionPatterns(DataSourceInclusionsExclusionsStringsProperty exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder exclusionPatterns(IResolvable exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(DataSourceInclusionsExclusionsStringsProperty inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder inclusionPatterns(IResolvable inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder useChangeLog(Boolean useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder useChangeLog(IResolvable useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public SharePointConfigurationProperty build() {
                return new Jsii.Proxy(this.secretArn, this.sharePointVersion, this.urls, this.crawlAttachments, this.documentTitleFieldName, this.exclusionPatterns, this.fieldMappings, this.inclusionPatterns, this.useChangeLog, this.vpcConfiguration, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.ServiceNowServiceCatalogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowServiceCatalogConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getIncludeAttachmentFilePatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowServiceCatalogConfigurationProperty> {
            private String documentDataFieldName;
            private Object crawlAttachments;
            private String documentTitleFieldName;
            private Object excludeAttachmentFilePatterns;
            private Object fieldMappings;
            private Object includeAttachmentFilePatterns;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(DataSourceInclusionsExclusionsStringsProperty excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(IResolvable excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeAttachmentFilePatterns(DataSourceInclusionsExclusionsStringsProperty includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public Builder includeAttachmentFilePatterns(IResolvable includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public ServiceNowServiceCatalogConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.crawlAttachments, this.documentTitleFieldName, this.excludeAttachmentFilePatterns, this.fieldMappings, this.includeAttachmentFilePatterns, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowKnowledgeArticleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getIncludeAttachmentFilePatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowKnowledgeArticleConfigurationProperty> {
            private String documentDataFieldName;
            private Object crawlAttachments;
            private String documentTitleFieldName;
            private Object excludeAttachmentFilePatterns;
            private Object fieldMappings;
            private Object includeAttachmentFilePatterns;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(DataSourceInclusionsExclusionsStringsProperty excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(IResolvable excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeAttachmentFilePatterns(DataSourceInclusionsExclusionsStringsProperty includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public Builder includeAttachmentFilePatterns(IResolvable includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public ServiceNowKnowledgeArticleConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.crawlAttachments, this.documentTitleFieldName, this.excludeAttachmentFilePatterns, this.fieldMappings, this.includeAttachmentFilePatterns, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.ServiceNowConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getHostUrl();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServiceNowBuildVersion();

        @Nullable
        default public Object getKnowledgeArticleConfiguration() {
            return null;
        }

        @Nullable
        default public Object getServiceCatalogConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowConfigurationProperty> {
            private String hostUrl;
            private String secretArn;
            private String serviceNowBuildVersion;
            private Object knowledgeArticleConfiguration;
            private Object serviceCatalogConfiguration;

            public Builder hostUrl(String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serviceNowBuildVersion(String serviceNowBuildVersion) {
                this.serviceNowBuildVersion = serviceNowBuildVersion;
                return this;
            }

            public Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder knowledgeArticleConfiguration(IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            public Builder serviceCatalogConfiguration(IResolvable serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            public ServiceNowConfigurationProperty build() {
                return new Jsii.Proxy(this.hostUrl, this.secretArn, this.serviceNowBuildVersion, this.knowledgeArticleConfiguration, this.serviceCatalogConfiguration, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceStandardObjectConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @NotNull
        public String getName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectConfigurationProperty> {
            private String documentDataFieldName;
            private String name;
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardObjectConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.name, this.documentTitleFieldName, this.fieldMappings, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceStandardObjectConfigurationListProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectConfigurationListProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSalesforceStandardObjectConfigurationList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectConfigurationListProperty> {
            private Object salesforceStandardObjectConfigurationList;

            public Builder salesforceStandardObjectConfigurationList(IResolvable salesforceStandardObjectConfigurationList) {
                this.salesforceStandardObjectConfigurationList = salesforceStandardObjectConfigurationList;
                return this;
            }

            public Builder salesforceStandardObjectConfigurationList(List<? extends Object> salesforceStandardObjectConfigurationList) {
                this.salesforceStandardObjectConfigurationList = salesforceStandardObjectConfigurationList;
                return this;
            }

            public SalesforceStandardObjectConfigurationListProperty build() {
                return new Jsii.Proxy(this.salesforceStandardObjectConfigurationList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectAttachmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectAttachmentConfigurationProperty> {
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardObjectAttachmentConfigurationProperty build() {
                return new Jsii.Proxy(this.documentTitleFieldName, this.fieldMappings, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardKnowledgeArticleTypeConfigurationProperty> {
            private String documentDataFieldName;
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.documentTitleFieldName, this.fieldMappings, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceKnowledgeArticleStateListProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceKnowledgeArticleStateListProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSalesforceKnowledgeArticleStateList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceKnowledgeArticleStateListProperty> {
            private List<String> salesforceKnowledgeArticleStateList;

            public Builder salesforceKnowledgeArticleStateList(List<String> salesforceKnowledgeArticleStateList) {
                this.salesforceKnowledgeArticleStateList = salesforceKnowledgeArticleStateList;
                return this;
            }

            public SalesforceKnowledgeArticleStateListProperty build() {
                return new Jsii.Proxy(this.salesforceKnowledgeArticleStateList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceKnowledgeArticleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIncludedStates();

        @Nullable
        default public Object getCustomKnowledgeArticleTypeConfigurations() {
            return null;
        }

        @Nullable
        default public Object getStandardKnowledgeArticleTypeConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceKnowledgeArticleConfigurationProperty> {
            private Object includedStates;
            private Object customKnowledgeArticleTypeConfigurations;
            private Object standardKnowledgeArticleTypeConfiguration;

            public Builder includedStates(SalesforceKnowledgeArticleStateListProperty includedStates) {
                this.includedStates = includedStates;
                return this;
            }

            public Builder includedStates(IResolvable includedStates) {
                this.includedStates = includedStates;
                return this;
            }

            public Builder customKnowledgeArticleTypeConfigurations(SalesforceCustomKnowledgeArticleTypeConfigurationListProperty customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            public Builder customKnowledgeArticleTypeConfigurations(IResolvable customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            public Builder standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            public Builder standardKnowledgeArticleTypeConfiguration(IResolvable standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            public SalesforceKnowledgeArticleConfigurationProperty build() {
                return new Jsii.Proxy(this.includedStates, this.customKnowledgeArticleTypeConfigurations, this.standardKnowledgeArticleTypeConfiguration, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @NotNull
        public String getName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceCustomKnowledgeArticleTypeConfigurationProperty> {
            private String documentDataFieldName;
            private String name;
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceCustomKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.name, this.documentTitleFieldName, this.fieldMappings, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationListProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceCustomKnowledgeArticleTypeConfigurationListProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSalesforceCustomKnowledgeArticleTypeConfigurationList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceCustomKnowledgeArticleTypeConfigurationListProperty> {
            private Object salesforceCustomKnowledgeArticleTypeConfigurationList;

            public Builder salesforceCustomKnowledgeArticleTypeConfigurationList(IResolvable salesforceCustomKnowledgeArticleTypeConfigurationList) {
                this.salesforceCustomKnowledgeArticleTypeConfigurationList = salesforceCustomKnowledgeArticleTypeConfigurationList;
                return this;
            }

            public Builder salesforceCustomKnowledgeArticleTypeConfigurationList(List<? extends Object> salesforceCustomKnowledgeArticleTypeConfigurationList) {
                this.salesforceCustomKnowledgeArticleTypeConfigurationList = salesforceCustomKnowledgeArticleTypeConfigurationList;
                return this;
            }

            public SalesforceCustomKnowledgeArticleTypeConfigurationListProperty build() {
                return new Jsii.Proxy(this.salesforceCustomKnowledgeArticleTypeConfigurationList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServerUrl();

        @Nullable
        default public Object getChatterFeedConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public Object getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getIncludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getKnowledgeArticleConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStandardObjectAttachmentConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStandardObjectConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceConfigurationProperty> {
            private String secretArn;
            private String serverUrl;
            private Object chatterFeedConfiguration;
            private Object crawlAttachments;
            private Object excludeAttachmentFilePatterns;
            private Object includeAttachmentFilePatterns;
            private Object knowledgeArticleConfiguration;
            private Object standardObjectAttachmentConfiguration;
            private Object standardObjectConfigurations;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serverUrl(String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            public Builder chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            public Builder chatterFeedConfiguration(IResolvable chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(DataSourceInclusionsExclusionsStringsProperty excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(IResolvable excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder includeAttachmentFilePatterns(DataSourceInclusionsExclusionsStringsProperty includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public Builder includeAttachmentFilePatterns(IResolvable includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder knowledgeArticleConfiguration(IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            public Builder standardObjectAttachmentConfiguration(IResolvable standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            public Builder standardObjectConfigurations(SalesforceStandardObjectConfigurationListProperty standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            public Builder standardObjectConfigurations(IResolvable standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            public SalesforceConfigurationProperty build() {
                return new Jsii.Proxy(this.secretArn, this.serverUrl, this.chatterFeedConfiguration, this.crawlAttachments, this.excludeAttachmentFilePatterns, this.includeAttachmentFilePatterns, this.knowledgeArticleConfiguration, this.standardObjectAttachmentConfiguration, this.standardObjectConfigurations, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceChatterFeedIncludeFilterTypesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceChatterFeedIncludeFilterTypesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSalesforceChatterFeedIncludeFilterTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceChatterFeedIncludeFilterTypesProperty> {
            private List<String> salesforceChatterFeedIncludeFilterTypes;

            public Builder salesforceChatterFeedIncludeFilterTypes(List<String> salesforceChatterFeedIncludeFilterTypes) {
                this.salesforceChatterFeedIncludeFilterTypes = salesforceChatterFeedIncludeFilterTypes;
                return this;
            }

            public SalesforceChatterFeedIncludeFilterTypesProperty build() {
                return new Jsii.Proxy(this.salesforceChatterFeedIncludeFilterTypes, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.SalesforceChatterFeedConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceChatterFeedConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getIncludeFilterTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceChatterFeedConfigurationProperty> {
            private String documentDataFieldName;
            private String documentTitleFieldName;
            private Object fieldMappings;
            private Object includeFilterTypes;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeFilterTypes(SalesforceChatterFeedIncludeFilterTypesProperty includeFilterTypes) {
                this.includeFilterTypes = includeFilterTypes;
                return this;
            }

            public Builder includeFilterTypes(IResolvable includeFilterTypes) {
                this.includeFilterTypes = includeFilterTypes;
                return this;
            }

            public SalesforceChatterFeedConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.documentTitleFieldName, this.fieldMappings, this.includeFilterTypes, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.S3PathProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3PathProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3PathProperty> {
            private String bucket;
            private String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public S3PathProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @Nullable
        default public Object getAccessControlListConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDocumentsMetadataConfiguration() {
            return null;
        }

        @Nullable
        default public Object getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getInclusionPrefixes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            private String bucketName;
            private Object accessControlListConfiguration;
            private Object documentsMetadataConfiguration;
            private Object exclusionPatterns;
            private Object inclusionPrefixes;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder accessControlListConfiguration(AccessControlListConfigurationProperty accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            public Builder accessControlListConfiguration(IResolvable accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            public Builder documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            public Builder documentsMetadataConfiguration(IResolvable documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            public Builder exclusionPatterns(DataSourceInclusionsExclusionsStringsProperty exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder exclusionPatterns(IResolvable exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder inclusionPrefixes(DataSourceInclusionsExclusionsStringsProperty inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            public Builder inclusionPrefixes(IResolvable inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            public S3DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this.bucketName, this.accessControlListConfiguration, this.documentsMetadataConfiguration, this.exclusionPatterns, this.inclusionPrefixes, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.OneDriveUsersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveUsersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOneDriveUserList() {
            return null;
        }

        @Nullable
        default public Object getOneDriveUserS3Path() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveUsersProperty> {
            private Object oneDriveUserList;
            private Object oneDriveUserS3Path;

            public Builder oneDriveUserList(OneDriveUserListProperty oneDriveUserList) {
                this.oneDriveUserList = oneDriveUserList;
                return this;
            }

            public Builder oneDriveUserList(IResolvable oneDriveUserList) {
                this.oneDriveUserList = oneDriveUserList;
                return this;
            }

            public Builder oneDriveUserS3Path(S3PathProperty oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            public Builder oneDriveUserS3Path(IResolvable oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            public OneDriveUsersProperty build() {
                return new Jsii.Proxy(this.oneDriveUserList, this.oneDriveUserS3Path, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.OneDriveUserListProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveUserListProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getOneDriveUserList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveUserListProperty> {
            private List<String> oneDriveUserList;

            public Builder oneDriveUserList(List<String> oneDriveUserList) {
                this.oneDriveUserList = oneDriveUserList;
                return this;
            }

            public OneDriveUserListProperty build() {
                return new Jsii.Proxy(this.oneDriveUserList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.OneDriveConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getOneDriveUsers();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getTenantDomain();

        @Nullable
        default public Object getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getInclusionPatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveConfigurationProperty> {
            private Object oneDriveUsers;
            private String secretArn;
            private String tenantDomain;
            private Object exclusionPatterns;
            private Object fieldMappings;
            private Object inclusionPatterns;

            public Builder oneDriveUsers(OneDriveUsersProperty oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            public Builder oneDriveUsers(IResolvable oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder tenantDomain(String tenantDomain) {
                this.tenantDomain = tenantDomain;
                return this;
            }

            public Builder exclusionPatterns(DataSourceInclusionsExclusionsStringsProperty exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder exclusionPatterns(IResolvable exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(DataSourceInclusionsExclusionsStringsProperty inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder inclusionPatterns(IResolvable inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public OneDriveConfigurationProperty build() {
                return new Jsii.Proxy(this.oneDriveUsers, this.secretArn, this.tenantDomain, this.exclusionPatterns, this.fieldMappings, this.inclusionPatterns, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DocumentsMetadataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocumentsMetadataConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Prefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocumentsMetadataConfigurationProperty> {
            private String s3Prefix;

            public Builder s3Prefix(String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            public DocumentsMetadataConfigurationProperty build() {
                return new Jsii.Proxy(this.s3Prefix, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DatabaseConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumnConfiguration();

        @NotNull
        public Object getConnectionConfiguration();

        @NotNull
        public String getDatabaseEngineType();

        @Nullable
        default public Object getAclConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSqlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseConfigurationProperty> {
            private Object columnConfiguration;
            private Object connectionConfiguration;
            private String databaseEngineType;
            private Object aclConfiguration;
            private Object sqlConfiguration;
            private Object vpcConfiguration;

            public Builder columnConfiguration(ColumnConfigurationProperty columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            public Builder columnConfiguration(IResolvable columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            public Builder connectionConfiguration(ConnectionConfigurationProperty connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            public Builder connectionConfiguration(IResolvable connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            public Builder databaseEngineType(String databaseEngineType) {
                this.databaseEngineType = databaseEngineType;
                return this;
            }

            public Builder aclConfiguration(AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            public Builder aclConfiguration(IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            public Builder sqlConfiguration(SqlConfigurationProperty sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            public Builder sqlConfiguration(IResolvable sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public DatabaseConfigurationProperty build() {
                return new Jsii.Proxy(this.columnConfiguration, this.connectionConfiguration, this.databaseEngineType, this.aclConfiguration, this.sqlConfiguration, this.vpcConfiguration, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DataSourceVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceVpcConfigurationProperty> {
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public DataSourceVpcConfigurationProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnetIds, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DataSourceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceToIndexFieldMappingProperty> {
            private String dataSourceFieldName;
            private String indexFieldName;
            private String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public DataSourceToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this.dataSourceFieldName, this.indexFieldName, this.dateFieldFormat, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DataSourceToIndexFieldMappingListProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceToIndexFieldMappingListProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataSourceToIndexFieldMappingList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceToIndexFieldMappingListProperty> {
            private Object dataSourceToIndexFieldMappingList;

            public Builder dataSourceToIndexFieldMappingList(IResolvable dataSourceToIndexFieldMappingList) {
                this.dataSourceToIndexFieldMappingList = dataSourceToIndexFieldMappingList;
                return this;
            }

            public Builder dataSourceToIndexFieldMappingList(List<? extends Object> dataSourceToIndexFieldMappingList) {
                this.dataSourceToIndexFieldMappingList = dataSourceToIndexFieldMappingList;
                return this;
            }

            public DataSourceToIndexFieldMappingListProperty build() {
                return new Jsii.Proxy(this.dataSourceToIndexFieldMappingList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DataSourceInclusionsExclusionsStringsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceInclusionsExclusionsStringsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getDataSourceInclusionsExclusionsStrings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceInclusionsExclusionsStringsProperty> {
            private List<String> dataSourceInclusionsExclusionsStrings;

            public Builder dataSourceInclusionsExclusionsStrings(List<String> dataSourceInclusionsExclusionsStrings) {
                this.dataSourceInclusionsExclusionsStrings = dataSourceInclusionsExclusionsStrings;
                return this;
            }

            public DataSourceInclusionsExclusionsStringsProperty build() {
                return new Jsii.Proxy(this.dataSourceInclusionsExclusionsStrings, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDatabaseConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOneDriveConfiguration() {
            return null;
        }

        @Nullable
        default public Object getS3Configuration() {
            return null;
        }

        @Nullable
        default public Object getSalesforceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getServiceNowConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSharePointConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            private Object databaseConfiguration;
            private Object oneDriveConfiguration;
            private Object s3Configuration;
            private Object salesforceConfiguration;
            private Object serviceNowConfiguration;
            private Object sharePointConfiguration;

            public Builder databaseConfiguration(DatabaseConfigurationProperty databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            public Builder databaseConfiguration(IResolvable databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            public Builder oneDriveConfiguration(OneDriveConfigurationProperty oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            public Builder oneDriveConfiguration(IResolvable oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            public Builder s3Configuration(S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder salesforceConfiguration(SalesforceConfigurationProperty salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder salesforceConfiguration(IResolvable salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder serviceNowConfiguration(ServiceNowConfigurationProperty serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            public Builder serviceNowConfiguration(IResolvable serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(SharePointConfigurationProperty sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(IResolvable sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this.databaseConfiguration, this.oneDriveConfiguration, this.s3Configuration, this.salesforceConfiguration, this.serviceNowConfiguration, this.sharePointConfiguration, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.ConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseHost();

        @NotNull
        public String getDatabaseName();

        @NotNull
        public Number getDatabasePort();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionConfigurationProperty> {
            private String databaseHost;
            private String databaseName;
            private Number databasePort;
            private String secretArn;
            private String tableName;

            public Builder databaseHost(String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder databasePort(Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public ConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this.databaseHost, this.databaseName, this.databasePort, this.secretArn, this.tableName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.ColumnConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getChangeDetectingColumns();

        @NotNull
        public String getDocumentDataColumnName();

        @NotNull
        public String getDocumentIdColumnName();

        @Nullable
        default public String getDocumentTitleColumnName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnConfigurationProperty> {
            private Object changeDetectingColumns;
            private String documentDataColumnName;
            private String documentIdColumnName;
            private String documentTitleColumnName;
            private Object fieldMappings;

            public Builder changeDetectingColumns(ChangeDetectingColumnsProperty changeDetectingColumns) {
                this.changeDetectingColumns = changeDetectingColumns;
                return this;
            }

            public Builder changeDetectingColumns(IResolvable changeDetectingColumns) {
                this.changeDetectingColumns = changeDetectingColumns;
                return this;
            }

            public Builder documentDataColumnName(String documentDataColumnName) {
                this.documentDataColumnName = documentDataColumnName;
                return this;
            }

            public Builder documentIdColumnName(String documentIdColumnName) {
                this.documentIdColumnName = documentIdColumnName;
                return this;
            }

            public Builder documentTitleColumnName(String documentTitleColumnName) {
                this.documentTitleColumnName = documentTitleColumnName;
                return this;
            }

            public Builder fieldMappings(DataSourceToIndexFieldMappingListProperty fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public ColumnConfigurationProperty build() {
                return new Jsii.Proxy(this.changeDetectingColumns, this.documentDataColumnName, this.documentIdColumnName, this.documentTitleColumnName, this.fieldMappings, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.ChangeDetectingColumnsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ChangeDetectingColumnsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getChangeDetectingColumns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ChangeDetectingColumnsProperty> {
            private List<String> changeDetectingColumns;

            public Builder changeDetectingColumns(List<String> changeDetectingColumns) {
                this.changeDetectingColumns = changeDetectingColumns;
                return this;
            }

            public ChangeDetectingColumnsProperty build() {
                return new Jsii.Proxy(this.changeDetectingColumns, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.AclConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AclConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAllowedGroupsColumnName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AclConfigurationProperty> {
            private String allowedGroupsColumnName;

            public Builder allowedGroupsColumnName(String allowedGroupsColumnName) {
                this.allowedGroupsColumnName = allowedGroupsColumnName;
                return this;
            }

            public AclConfigurationProperty build() {
                return new Jsii.Proxy(this.allowedGroupsColumnName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_kendra.CfnDataSource.AccessControlListConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessControlListConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKeyPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessControlListConfigurationProperty> {
            private String keyPath;

            public Builder keyPath(String keyPath) {
                this.keyPath = keyPath;
                return this;
            }

            public AccessControlListConfigurationProperty build() {
                return new Jsii.Proxy(this.keyPath, null);
            }
        }
    }
}

