/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.assets.FollowMode;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.AssetHashType;
import software.amazon.awscdk.core.BundlingOptions;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.CodeConfig;
import software.amazon.awscdk.services.lambda.ResourceBindOptions;
import software.amazon.awscdk.services.s3.assets.AssetOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_lambda.AssetCode")
public class AssetCode
extends Code {
    protected AssetCode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetCode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetCode(@NotNull String path, @Nullable AssetOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required"), options});
    }

    public AssetCode(@NotNull String path) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @Override
    @NotNull
    public CodeConfig bind(@NotNull Construct scope) {
        return (CodeConfig)this.jsiiCall("bind", CodeConfig.class, new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @Override
    public void bindToResource(@NotNull CfnResource resource, @Nullable ResourceBindOptions options) {
        this.jsiiCall("bindToResource", NativeType.VOID, new Object[]{Objects.requireNonNull(resource, "resource is required"), options});
    }

    @Override
    public void bindToResource(@NotNull CfnResource resource) {
        this.jsiiCall("bindToResource", NativeType.VOID, new Object[]{Objects.requireNonNull(resource, "resource is required")});
    }

    @Override
    @NotNull
    public Boolean getIsInline() {
        return (Boolean)this.jsiiGet("isInline", Boolean.class);
    }

    @NotNull
    public String getPath() {
        return (String)this.jsiiGet("path", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetCode> {
        private final String path;
        private AssetOptions.Builder options;

        public static Builder create(String path) {
            return new Builder(path);
        }

        private Builder(String path) {
            this.path = path;
        }

        @Deprecated
        public Builder exclude(List<String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        @Deprecated
        public Builder follow(FollowMode follow) {
            this.options().follow(follow);
            return this;
        }

        public Builder assetHash(String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        public Builder assetHashType(AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        public Builder bundling(BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        public Builder readers(List<? extends IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        @Deprecated
        public Builder sourceHash(String sourceHash) {
            this.options().sourceHash(sourceHash);
            return this;
        }

        public AssetCode build() {
            return new AssetCode(this.path, this.options != null ? this.options.build() : null);
        }

        private AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new AssetOptions.Builder();
            }
            return this.options;
        }
    }
}

