/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.opsworks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.opsworks.CfnApp;
import software.amazon.awscdk.services.opsworks.CfnAppProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_opsworks.CfnApp")
public class CfnApp
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApp.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnApp(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApp(@NotNull Construct scope, @NotNull String id, @NotNull CfnAppProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getStackId() {
        return (String)this.jsiiGet("stackId", String.class);
    }

    public void setStackId(@NotNull String value) {
        this.jsiiSet("stackId", Objects.requireNonNull(value, "stackId is required"));
    }

    @NotNull
    public String getType() {
        return (String)this.jsiiGet("type", String.class);
    }

    public void setType(@NotNull String value) {
        this.jsiiSet("type", Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getAppSource() {
        return this.jsiiGet("appSource", Object.class);
    }

    public void setAppSource(@Nullable SourceProperty value) {
        this.jsiiSet("appSource", value);
    }

    public void setAppSource(@Nullable IResolvable value) {
        this.jsiiSet("appSource", value);
    }

    @Nullable
    public Object getAttributes() {
        return this.jsiiGet("attributes", Object.class);
    }

    public void setAttributes(@Nullable IResolvable value) {
        this.jsiiSet("attributes", value);
    }

    public void setAttributes(@Nullable Map<String, String> value) {
        this.jsiiSet("attributes", value);
    }

    @Nullable
    public Object getDataSources() {
        return this.jsiiGet("dataSources", Object.class);
    }

    public void setDataSources(@Nullable IResolvable value) {
        this.jsiiSet("dataSources", value);
    }

    public void setDataSources(@Nullable List<Object> value) {
        this.jsiiSet("dataSources", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public List<String> getDomains() {
        return Optional.ofNullable((List)this.jsiiGet("domains", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setDomains(@Nullable List<String> value) {
        this.jsiiSet("domains", value);
    }

    @Nullable
    public Object getEnableSsl() {
        return this.jsiiGet("enableSsl", Object.class);
    }

    public void setEnableSsl(@Nullable Boolean value) {
        this.jsiiSet("enableSsl", value);
    }

    public void setEnableSsl(@Nullable IResolvable value) {
        this.jsiiSet("enableSsl", value);
    }

    @Nullable
    public Object getEnvironment() {
        return this.jsiiGet("environment", Object.class);
    }

    public void setEnvironment(@Nullable IResolvable value) {
        this.jsiiSet("environment", value);
    }

    public void setEnvironment(@Nullable List<Object> value) {
        this.jsiiSet("environment", value);
    }

    @Nullable
    public String getShortname() {
        return (String)this.jsiiGet("shortname", String.class);
    }

    public void setShortname(@Nullable String value) {
        this.jsiiSet("shortname", value);
    }

    @Nullable
    public Object getSslConfiguration() {
        return this.jsiiGet("sslConfiguration", Object.class);
    }

    public void setSslConfiguration(@Nullable SslConfigurationProperty value) {
        this.jsiiSet("sslConfiguration", value);
    }

    public void setSslConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("sslConfiguration", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApp> {
        private final Construct scope;
        private final String id;
        private final CfnAppProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAppProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder stackId(String stackId) {
            this.props.stackId(stackId);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder appSource(SourceProperty appSource) {
            this.props.appSource(appSource);
            return this;
        }

        public Builder appSource(IResolvable appSource) {
            this.props.appSource(appSource);
            return this;
        }

        public Builder attributes(IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.props.attributes(attributes);
            return this;
        }

        public Builder dataSources(IResolvable dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        public Builder dataSources(List<? extends Object> dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder domains(List<String> domains) {
            this.props.domains(domains);
            return this;
        }

        public Builder enableSsl(Boolean enableSsl) {
            this.props.enableSsl(enableSsl);
            return this;
        }

        public Builder enableSsl(IResolvable enableSsl) {
            this.props.enableSsl(enableSsl);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environment(List<? extends Object> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder shortname(String shortname) {
            this.props.shortname(shortname);
            return this;
        }

        public Builder sslConfiguration(SslConfigurationProperty sslConfiguration) {
            this.props.sslConfiguration(sslConfiguration);
            return this;
        }

        public Builder sslConfiguration(IResolvable sslConfiguration) {
            this.props.sslConfiguration(sslConfiguration);
            return this;
        }

        public CfnApp build() {
            return new CfnApp(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_opsworks.CfnApp.SslConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SslConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCertificate() {
            return null;
        }

        @Nullable
        default public String getChain() {
            return null;
        }

        @Nullable
        default public String getPrivateKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SslConfigurationProperty> {
            private String certificate;
            private String chain;
            private String privateKey;

            public Builder certificate(String certificate) {
                this.certificate = certificate;
                return this;
            }

            public Builder chain(String chain) {
                this.chain = chain;
                return this;
            }

            public Builder privateKey(String privateKey) {
                this.privateKey = privateKey;
                return this;
            }

            public SslConfigurationProperty build() {
                return new Jsii.Proxy(this.certificate, this.chain, this.privateKey, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_opsworks.CfnApp.SourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public String getRevision() {
            return null;
        }

        @Nullable
        default public String getSshKey() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceProperty> {
            private String password;
            private String revision;
            private String sshKey;
            private String type;
            private String url;
            private String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder revision(String revision) {
                this.revision = revision;
                return this;
            }

            public Builder sshKey(String sshKey) {
                this.sshKey = sshKey;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public SourceProperty build() {
                return new Jsii.Proxy(this.password, this.revision, this.sshKey, this.type, this.url, this.username, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_opsworks.CfnApp.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentVariableProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        @Nullable
        default public Object getSecure() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            private String key;
            private String value;
            private Object secure;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder secure(Boolean secure) {
                this.secure = secure;
                return this;
            }

            public Builder secure(IResolvable secure) {
                this.secure = secure;
                return this;
            }

            public EnvironmentVariableProperty build() {
                return new Jsii.Proxy(this.key, this.value, this.secure, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_opsworks.CfnApp.DataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceProperty> {
            private String arn;
            private String databaseName;
            private String type;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DataSourceProperty build() {
                return new Jsii.Proxy(this.arn, this.databaseName, this.type, null);
            }
        }
    }
}

