/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns.subscriptions;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.ITopicSubscription;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sns.SubscriptionProtocol;
import software.amazon.awscdk.services.sns.TopicSubscriptionConfig;
import software.amazon.awscdk.services.sns.subscriptions.UrlSubscriptionProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_sns_subscriptions.UrlSubscription")
public class UrlSubscription
extends JsiiObject
implements ITopicSubscription {
    protected UrlSubscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UrlSubscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public UrlSubscription(@NotNull String url, @Nullable UrlSubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(url, "url is required"), props});
    }

    public UrlSubscription(@NotNull String url) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(url, "url is required")});
    }

    @Override
    @NotNull
    public TopicSubscriptionConfig bind(@NotNull ITopic _topic) {
        return (TopicSubscriptionConfig)this.jsiiCall("bind", TopicSubscriptionConfig.class, new Object[]{Objects.requireNonNull(_topic, "_topic is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<UrlSubscription> {
        private final String url;
        private UrlSubscriptionProps.Builder props;

        public static Builder create(String url) {
            return new Builder(url);
        }

        private Builder(String url) {
            this.url = url;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder filterPolicy(Map<String, ? extends SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        public Builder protocol(SubscriptionProtocol protocol) {
            this.props().protocol(protocol);
            return this;
        }

        public Builder rawMessageDelivery(Boolean rawMessageDelivery) {
            this.props().rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public UrlSubscription build() {
            return new UrlSubscription(this.url, this.props != null ? this.props.build() : null);
        }

        private UrlSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new UrlSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}

