/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.cloudassembly.schema.ArtifactManifest;
import software.amazon.awscdk.cloudassembly.schema.ArtifactType;
import software.amazon.awscdk.cloudassembly.schema.AssetManifestProperties;
import software.amazon.awscdk.cloudassembly.schema.AwsCloudFormationStackProperties;
import software.amazon.awscdk.cloudassembly.schema.MetadataEntry;
import software.amazon.awscdk.cloudassembly.schema.NestedCloudAssemblyProperties;
import software.amazon.awscdk.cloudassembly.schema.TreeArtifactProperties;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.cxapi.CloudArtifact;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.Environment;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.cx_api.CloudFormationStackArtifact")
public class CloudFormationStackArtifact
extends CloudArtifact {
    protected CloudFormationStackArtifact(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackArtifact(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFormationStackArtifact(@NotNull CloudAssembly assembly, @NotNull String artifactId, @NotNull ArtifactManifest artifact) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assembly, "assembly is required"), Objects.requireNonNull(artifactId, "artifactId is required"), Objects.requireNonNull(artifact, "artifact is required")});
    }

    @NotNull
    public List<Object> getAssets() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"assets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDisplayName() {
        return (String)Kernel.get((Object)((Object)this), (String)"displayName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Environment getEnvironment() {
        return (Environment)Kernel.get((Object)((Object)this), (String)"environment", (NativeType)NativeType.forClass(Environment.class));
    }

    @Deprecated
    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getOriginalName() {
        return (String)Kernel.get((Object)((Object)this), (String)"originalName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"parameters", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getStackName() {
        return (String)Kernel.get((Object)((Object)this), (String)"stackName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Object getTemplate() {
        return Kernel.get((Object)((Object)this), (String)"template", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public String getTemplateFile() {
        return (String)Kernel.get((Object)((Object)this), (String)"templateFile", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getTemplateFullPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"templateFullPath", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getAssumeRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"assumeRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getBootstrapStackVersionSsmParameter() {
        return (String)Kernel.get((Object)((Object)this), (String)"bootstrapStackVersionSsmParameter", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getCloudFormationExecutionRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"cloudFormationExecutionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Number getRequiresBootstrapStackVersion() {
        return (Number)Kernel.get((Object)((Object)this), (String)"requiresBootstrapStackVersion", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public String getStackTemplateAssetObjectUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"stackTemplateAssetObjectUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Boolean getTerminationProtection() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"terminationProtection", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public Boolean getValidateOnSynth() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"validateOnSynth", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudFormationStackArtifact> {
        private final CloudAssembly assembly;
        private final String artifactId;
        private final ArtifactManifest.Builder artifact;

        public static Builder create(CloudAssembly assembly, String artifactId) {
            return new Builder(assembly, artifactId);
        }

        private Builder(CloudAssembly assembly, String artifactId) {
            this.assembly = assembly;
            this.artifactId = artifactId;
            this.artifact = new ArtifactManifest.Builder();
        }

        public Builder type(ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        public Builder displayName(String displayName) {
            this.artifact.displayName(displayName);
            return this;
        }

        public Builder environment(String environment) {
            this.artifact.environment(environment);
            return this;
        }

        public Builder metadata(Map<String, ? extends List<? extends MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        public Builder properties(AwsCloudFormationStackProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(AssetManifestProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(TreeArtifactProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(NestedCloudAssemblyProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public CloudFormationStackArtifact build() {
            return new CloudFormationStackArtifact(this.assembly, this.artifactId, this.artifact.build());
        }
    }
}

