/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.amplify;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.amplify.AppProps;
import software.amazon.awscdk.services.amplify.AutoBranchCreation;
import software.amazon.awscdk.services.amplify.BasicAuth;
import software.amazon.awscdk.services.amplify.Branch;
import software.amazon.awscdk.services.amplify.BranchOptions;
import software.amazon.awscdk.services.amplify.CustomRule;
import software.amazon.awscdk.services.amplify.Domain;
import software.amazon.awscdk.services.amplify.DomainOptions;
import software.amazon.awscdk.services.amplify.IApp;
import software.amazon.awscdk.services.amplify.ISourceCodeProvider;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_amplify.App")
public class App
extends Resource
implements IApp,
IGrantable {
    protected App(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected App(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public App(@NotNull Construct scope, @NotNull String id, @NotNull AppProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IApp fromAppId(@NotNull Construct scope, @NotNull String id, @NotNull String appId) {
        return (IApp)JsiiObject.jsiiStaticCall(App.class, (String)"fromAppId", (NativeType)NativeType.forClass(IApp.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(appId, "appId is required")});
    }

    @NotNull
    public App addAutoBranchEnvironment(@NotNull String name, @NotNull String value) {
        return (App)Kernel.call((Object)this, (String)"addAutoBranchEnvironment", (NativeType)NativeType.forClass(App.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    @NotNull
    public Branch addBranch(@NotNull String id, @Nullable BranchOptions options) {
        return (Branch)Kernel.call((Object)this, (String)"addBranch", (NativeType)NativeType.forClass(Branch.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public Branch addBranch(@NotNull String id) {
        return (Branch)Kernel.call((Object)this, (String)"addBranch", (NativeType)NativeType.forClass(Branch.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public App addCustomRule(@NotNull CustomRule rule) {
        return (App)Kernel.call((Object)this, (String)"addCustomRule", (NativeType)NativeType.forClass(App.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @NotNull
    public Domain addDomain(@NotNull String id, @Nullable DomainOptions options) {
        return (Domain)Kernel.call((Object)this, (String)"addDomain", (NativeType)NativeType.forClass(Domain.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public Domain addDomain(@NotNull String id) {
        return (Domain)Kernel.call((Object)this, (String)"addDomain", (NativeType)NativeType.forClass(Domain.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public App addEnvironment(@NotNull String name, @NotNull String value) {
        return (App)Kernel.call((Object)this, (String)"addEnvironment", (NativeType)NativeType.forClass(App.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    @Override
    @NotNull
    public String getAppId() {
        return (String)Kernel.get((Object)this, (String)"appId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAppName() {
        return (String)Kernel.get((Object)this, (String)"appName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getArn() {
        return (String)Kernel.get((Object)this, (String)"arn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDefaultDomain() {
        return (String)Kernel.get((Object)this, (String)"defaultDomain", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<App> {
        private final Construct scope;
        private final String id;
        private final AppProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AppProps.Builder();
        }

        public Builder appName(String appName) {
            this.props.appName(appName);
            return this;
        }

        public Builder autoBranchCreation(AutoBranchCreation autoBranchCreation) {
            this.props.autoBranchCreation(autoBranchCreation);
            return this;
        }

        public Builder autoBranchDeletion(Boolean autoBranchDeletion) {
            this.props.autoBranchDeletion(autoBranchDeletion);
            return this;
        }

        public Builder basicAuth(BasicAuth basicAuth) {
            this.props.basicAuth(basicAuth);
            return this;
        }

        public Builder buildSpec(BuildSpec buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        public Builder customRules(List<? extends CustomRule> customRules) {
            this.props.customRules(customRules);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder sourceCodeProvider(ISourceCodeProvider sourceCodeProvider) {
            this.props.sourceCodeProvider(sourceCodeProvider);
            return this;
        }

        public App build() {
            return new App(this.scope, this.id, this.props.build());
        }
    }
}

