/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apigateway.IVpcLink;
import software.amazon.awscdk.services.apigateway.VpcLinkProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_apigateway.VpcLink")
public class VpcLink
extends Resource
implements IVpcLink {
    protected VpcLink(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcLink(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public VpcLink(@NotNull Construct scope, @NotNull String id, @Nullable VpcLinkProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public VpcLink(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IVpcLink fromVpcLinkId(@NotNull Construct scope, @NotNull String id, @NotNull String vpcLinkId) {
        return (IVpcLink)JsiiObject.jsiiStaticCall(VpcLink.class, (String)"fromVpcLinkId", (NativeType)NativeType.forClass(IVpcLink.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(vpcLinkId, "vpcLinkId is required")});
    }

    public void addTargets(INetworkLoadBalancer ... targets) {
        Kernel.call((Object)this, (String)"addTargets", (NativeType)NativeType.VOID, (Object[])Arrays.stream(targets).toArray(Object[]::new));
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public String getVpcLinkId() {
        return (String)Kernel.get((Object)this, (String)"vpcLinkId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<VpcLink> {
        private final Construct scope;
        private final String id;
        private VpcLinkProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder targets(List<? extends INetworkLoadBalancer> targets) {
            this.props().targets(targets);
            return this;
        }

        public Builder vpcLinkName(String vpcLinkName) {
            this.props().vpcLinkName(vpcLinkName);
            return this;
        }

        public VpcLink build() {
            return new VpcLink(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private VpcLinkProps.Builder props() {
            if (this.props == null) {
                this.props = new VpcLinkProps.Builder();
            }
            return this.props;
        }
    }
}

