/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.backup;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.backup.BackupPlanProps;
import software.amazon.awscdk.services.backup.BackupPlanRule;
import software.amazon.awscdk.services.backup.BackupSelection;
import software.amazon.awscdk.services.backup.BackupSelectionOptions;
import software.amazon.awscdk.services.backup.IBackupPlan;
import software.amazon.awscdk.services.backup.IBackupVault;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_backup.BackupPlan")
public class BackupPlan
extends Resource
implements IBackupPlan {
    protected BackupPlan(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupPlan(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BackupPlan(@NotNull Construct scope, @NotNull String id, @Nullable BackupPlanProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public BackupPlan(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static BackupPlan daily35DayRetention(@NotNull Construct scope, @NotNull String id, @Nullable IBackupVault backupVault) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"daily35DayRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), backupVault});
    }

    @NotNull
    public static BackupPlan daily35DayRetention(@NotNull Construct scope, @NotNull String id) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"daily35DayRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static BackupPlan dailyMonthly1YearRetention(@NotNull Construct scope, @NotNull String id, @Nullable IBackupVault backupVault) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"dailyMonthly1YearRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), backupVault});
    }

    @NotNull
    public static BackupPlan dailyMonthly1YearRetention(@NotNull Construct scope, @NotNull String id) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"dailyMonthly1YearRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static BackupPlan dailyWeeklyMonthly5YearRetention(@NotNull Construct scope, @NotNull String id, @Nullable IBackupVault backupVault) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"dailyWeeklyMonthly5YearRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), backupVault});
    }

    @NotNull
    public static BackupPlan dailyWeeklyMonthly5YearRetention(@NotNull Construct scope, @NotNull String id) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"dailyWeeklyMonthly5YearRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static BackupPlan dailyWeeklyMonthly7YearRetention(@NotNull Construct scope, @NotNull String id, @Nullable IBackupVault backupVault) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"dailyWeeklyMonthly7YearRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), backupVault});
    }

    @NotNull
    public static BackupPlan dailyWeeklyMonthly7YearRetention(@NotNull Construct scope, @NotNull String id) {
        return (BackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"dailyWeeklyMonthly7YearRetention", (NativeType)NativeType.forClass(BackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IBackupPlan fromBackupPlanId(@NotNull Construct scope, @NotNull String id, @NotNull String backupPlanId) {
        return (IBackupPlan)JsiiObject.jsiiStaticCall(BackupPlan.class, (String)"fromBackupPlanId", (NativeType)NativeType.forClass(IBackupPlan.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(backupPlanId, "backupPlanId is required")});
    }

    public void addRule(@NotNull BackupPlanRule rule) {
        Kernel.call((Object)this, (String)"addRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @NotNull
    public BackupSelection addSelection(@NotNull String id, @NotNull BackupSelectionOptions options) {
        return (BackupSelection)Kernel.call((Object)this, (String)"addSelection", (NativeType)NativeType.forClass(BackupSelection.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    public String getBackupPlanArn() {
        return (String)Kernel.get((Object)this, (String)"backupPlanArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBackupPlanId() {
        return (String)Kernel.get((Object)this, (String)"backupPlanId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IBackupVault getBackupVault() {
        return (IBackupVault)Kernel.get((Object)this, (String)"backupVault", (NativeType)NativeType.forClass(IBackupVault.class));
    }

    @NotNull
    public String getVersionId() {
        return (String)Kernel.get((Object)this, (String)"versionId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BackupPlan> {
        private final Construct scope;
        private final String id;
        private BackupPlanProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder backupPlanName(String backupPlanName) {
            this.props().backupPlanName(backupPlanName);
            return this;
        }

        public Builder backupPlanRules(List<? extends BackupPlanRule> backupPlanRules) {
            this.props().backupPlanRules(backupPlanRules);
            return this;
        }

        public Builder backupVault(IBackupVault backupVault) {
            this.props().backupVault(backupVault);
            return this;
        }

        public BackupPlan build() {
            return new BackupPlan(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private BackupPlanProps.Builder props() {
            if (this.props == null) {
                this.props = new BackupPlanProps.Builder();
            }
            return this.props;
        }
    }
}

