/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.batch.CfnJobDefinition;
import software.amazon.awscdk.services.batch.CfnJobDefinitionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition")
public class CfnJobDefinition
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnJobDefinition.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnJobDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnJobDefinition(@NotNull Construct scope, @NotNull String id, @NotNull CfnJobDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getParameters() {
        return Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@NotNull Object value) {
        Kernel.set((Object)this, (String)"parameters", (Object)Objects.requireNonNull(value, "parameters is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getContainerProperties() {
        return Kernel.get((Object)this, (String)"containerProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContainerProperties(@Nullable ContainerPropertiesProperty value) {
        Kernel.set((Object)this, (String)"containerProperties", (Object)value);
    }

    public void setContainerProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"containerProperties", (Object)value);
    }

    @Nullable
    public String getJobDefinitionName() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionName", (NativeType)NativeType.forClass(String.class));
    }

    public void setJobDefinitionName(@Nullable String value) {
        Kernel.set((Object)this, (String)"jobDefinitionName", (Object)value);
    }

    @Nullable
    public Object getNodeProperties() {
        return Kernel.get((Object)this, (String)"nodeProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNodeProperties(@Nullable NodePropertiesProperty value) {
        Kernel.set((Object)this, (String)"nodeProperties", (Object)value);
    }

    public void setNodeProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"nodeProperties", (Object)value);
    }

    @Nullable
    public List<String> getPlatformCapabilities() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"platformCapabilities", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPlatformCapabilities(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"platformCapabilities", value);
    }

    @Nullable
    public Object getPropagateTags() {
        return Kernel.get((Object)this, (String)"propagateTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPropagateTags(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"propagateTags", (Object)value);
    }

    public void setPropagateTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"propagateTags", (Object)value);
    }

    @Nullable
    public Object getRetryStrategy() {
        return Kernel.get((Object)this, (String)"retryStrategy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRetryStrategy(@Nullable RetryStrategyProperty value) {
        Kernel.set((Object)this, (String)"retryStrategy", (Object)value);
    }

    public void setRetryStrategy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"retryStrategy", (Object)value);
    }

    @Nullable
    public Object getTimeout() {
        return Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTimeout(@Nullable TimeoutProperty value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    public void setTimeout(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnJobDefinition> {
        private final Construct scope;
        private final String id;
        private final CfnJobDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnJobDefinitionProps.Builder();
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder containerProperties(ContainerPropertiesProperty containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        public Builder containerProperties(IResolvable containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        public Builder jobDefinitionName(String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        public Builder nodeProperties(NodePropertiesProperty nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        public Builder nodeProperties(IResolvable nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        public Builder parameters(Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder platformCapabilities(List<String> platformCapabilities) {
            this.props.platformCapabilities(platformCapabilities);
            return this;
        }

        public Builder propagateTags(Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder propagateTags(IResolvable propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder retryStrategy(RetryStrategyProperty retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        public Builder retryStrategy(IResolvable retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(TimeoutProperty timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder timeout(IResolvable timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public CfnJobDefinition build() {
            return new CfnJobDefinition(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.VolumesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEfsVolumeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHost() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumesProperty> {
            private Object efsVolumeConfiguration;
            private Object host;
            private String name;

            public Builder efsVolumeConfiguration(EfsVolumeConfigurationProperty efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            public Builder efsVolumeConfiguration(IResolvable efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            public Builder host(VolumesHostProperty host) {
                this.host = host;
                return this;
            }

            public Builder host(IResolvable host) {
                this.host = host;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public VolumesProperty build() {
                return new Jsii.Proxy(this.efsVolumeConfiguration, this.host, this.name);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.VolumesHostProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumesHostProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSourcePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumesHostProperty> {
            private String sourcePath;

            public Builder sourcePath(String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            public VolumesHostProperty build() {
                return new Jsii.Proxy(this.sourcePath);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UlimitProperty
    extends JsiiSerializable {
        @NotNull
        public Number getHardLimit();

        @NotNull
        public String getName();

        @NotNull
        public Number getSoftLimit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UlimitProperty> {
            private Number hardLimit;
            private String name;
            private Number softLimit;

            public Builder hardLimit(Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder softLimit(Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            public UlimitProperty build() {
                return new Jsii.Proxy(this.hardLimit, this.name, this.softLimit);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.TmpfsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TmpfsProperty
    extends JsiiSerializable {
        @NotNull
        public String getContainerPath();

        @NotNull
        public Number getSize();

        @Nullable
        default public List<String> getMountOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TmpfsProperty> {
            private String containerPath;
            private Number size;
            private List<String> mountOptions;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public Builder mountOptions(List<String> mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            public TmpfsProperty build() {
                return new Jsii.Proxy(this.containerPath, this.size, this.mountOptions);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.TimeoutProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeoutProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttemptDurationSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeoutProperty> {
            private Number attemptDurationSeconds;

            public Builder attemptDurationSeconds(Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            public TimeoutProperty build() {
                return new Jsii.Proxy(this.attemptDurationSeconds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.SecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecretProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValueFrom();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecretProperty> {
            private String name;
            private String valueFrom;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder valueFrom(String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            public SecretProperty build() {
                return new Jsii.Proxy(this.name, this.valueFrom);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.RetryStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetryStrategyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttempts() {
            return null;
        }

        @Nullable
        default public Object getEvaluateOnExit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetryStrategyProperty> {
            private Number attempts;
            private Object evaluateOnExit;

            public Builder attempts(Number attempts) {
                this.attempts = attempts;
                return this;
            }

            public Builder evaluateOnExit(IResolvable evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            public Builder evaluateOnExit(List<? extends Object> evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            public RetryStrategyProperty build() {
                return new Jsii.Proxy(this.attempts, this.evaluateOnExit);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceRequirementProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            private String type;
            private String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ResourceRequirementProperty build() {
                return new Jsii.Proxy(this.type, this.value);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.NodeRangePropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NodeRangePropertyProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetNodes();

        @Nullable
        default public Object getContainer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NodeRangePropertyProperty> {
            private String targetNodes;
            private Object container;

            public Builder targetNodes(String targetNodes) {
                this.targetNodes = targetNodes;
                return this;
            }

            public Builder container(ContainerPropertiesProperty container) {
                this.container = container;
                return this;
            }

            public Builder container(IResolvable container) {
                this.container = container;
                return this;
            }

            public NodeRangePropertyProperty build() {
                return new Jsii.Proxy(this.targetNodes, this.container);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.NodePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NodePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMainNode();

        @NotNull
        public Object getNodeRangeProperties();

        @NotNull
        public Number getNumNodes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NodePropertiesProperty> {
            private Number mainNode;
            private Object nodeRangeProperties;
            private Number numNodes;

            public Builder mainNode(Number mainNode) {
                this.mainNode = mainNode;
                return this;
            }

            public Builder nodeRangeProperties(IResolvable nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            public Builder nodeRangeProperties(List<? extends Object> nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            public Builder numNodes(Number numNodes) {
                this.numNodes = numNodes;
                return this;
            }

            public NodePropertiesProperty build() {
                return new Jsii.Proxy(this.mainNode, this.nodeRangeProperties, this.numNodes);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            private String assignPublicIp;

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this.assignPublicIp);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.MountPointsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MountPointsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        @Nullable
        default public String getSourceVolume() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MountPointsProperty> {
            private String containerPath;
            private Object readOnly;
            private String sourceVolume;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder sourceVolume(String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            public MountPointsProperty build() {
                return new Jsii.Proxy(this.containerPath, this.readOnly, this.sourceVolume);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.LogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogDriver();

        @Nullable
        default public Object getOptions() {
            return null;
        }

        @Nullable
        default public Object getSecretOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            private String logDriver;
            private Object options;
            private Object secretOptions;

            public Builder logDriver(String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            public Builder options(Object options) {
                this.options = options;
                return this;
            }

            public Builder secretOptions(IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public Builder secretOptions(List<? extends Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public LogConfigurationProperty build() {
                return new Jsii.Proxy(this.logDriver, this.options, this.secretOptions);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LinuxParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDevices() {
            return null;
        }

        @Nullable
        default public Object getInitProcessEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxSwap() {
            return null;
        }

        @Nullable
        default public Number getSharedMemorySize() {
            return null;
        }

        @Nullable
        default public Number getSwappiness() {
            return null;
        }

        @Nullable
        default public Object getTmpfs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            private Object devices;
            private Object initProcessEnabled;
            private Number maxSwap;
            private Number sharedMemorySize;
            private Number swappiness;
            private Object tmpfs;

            public Builder devices(IResolvable devices) {
                this.devices = devices;
                return this;
            }

            public Builder devices(List<? extends Object> devices) {
                this.devices = devices;
                return this;
            }

            public Builder initProcessEnabled(Boolean initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            public Builder initProcessEnabled(IResolvable initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            public Builder maxSwap(Number maxSwap) {
                this.maxSwap = maxSwap;
                return this;
            }

            public Builder sharedMemorySize(Number sharedMemorySize) {
                this.sharedMemorySize = sharedMemorySize;
                return this;
            }

            public Builder swappiness(Number swappiness) {
                this.swappiness = swappiness;
                return this;
            }

            public Builder tmpfs(IResolvable tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            public Builder tmpfs(List<? extends Object> tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            public LinuxParametersProperty build() {
                return new Jsii.Proxy(this.devices, this.initProcessEnabled, this.maxSwap, this.sharedMemorySize, this.swappiness, this.tmpfs);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.FargatePlatformConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FargatePlatformConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPlatformVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FargatePlatformConfigurationProperty> {
            private String platformVersion;

            public Builder platformVersion(String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            public FargatePlatformConfigurationProperty build() {
                return new Jsii.Proxy(this.platformVersion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.EvaluateOnExitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EvaluateOnExitProperty
    extends JsiiSerializable {
        @NotNull
        public String getAction();

        @Nullable
        default public String getOnExitCode() {
            return null;
        }

        @Nullable
        default public String getOnReason() {
            return null;
        }

        @Nullable
        default public String getOnStatusReason() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EvaluateOnExitProperty> {
            private String action;
            private String onExitCode;
            private String onReason;
            private String onStatusReason;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder onExitCode(String onExitCode) {
                this.onExitCode = onExitCode;
                return this;
            }

            public Builder onReason(String onReason) {
                this.onReason = onReason;
                return this;
            }

            public Builder onStatusReason(String onStatusReason) {
                this.onStatusReason = onStatusReason;
                return this;
            }

            public EvaluateOnExitProperty build() {
                return new Jsii.Proxy(this.action, this.onExitCode, this.onReason, this.onStatusReason);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.EnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentProperty> {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EnvironmentProperty build() {
                return new Jsii.Proxy(this.name, this.value);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.EfsVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EfsVolumeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        @Nullable
        default public Object getAuthorizationConfig() {
            return null;
        }

        @Nullable
        default public String getRootDirectory() {
            return null;
        }

        @Nullable
        default public String getTransitEncryption() {
            return null;
        }

        @Nullable
        default public Number getTransitEncryptionPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EfsVolumeConfigurationProperty> {
            private String fileSystemId;
            private Object authorizationConfig;
            private String rootDirectory;
            private String transitEncryption;
            private Number transitEncryptionPort;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder authorizationConfig(AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder authorizationConfig(IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder rootDirectory(String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            public Builder transitEncryption(String transitEncryption) {
                this.transitEncryption = transitEncryption;
                return this;
            }

            public Builder transitEncryptionPort(Number transitEncryptionPort) {
                this.transitEncryptionPort = transitEncryptionPort;
                return this;
            }

            public EfsVolumeConfigurationProperty build() {
                return new Jsii.Proxy(this.fileSystemId, this.authorizationConfig, this.rootDirectory, this.transitEncryption, this.transitEncryptionPort);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeviceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public String getHostPath() {
            return null;
        }

        @Nullable
        default public List<String> getPermissions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeviceProperty> {
            private String containerPath;
            private String hostPath;
            private List<String> permissions;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder hostPath(String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            public Builder permissions(List<String> permissions) {
                this.permissions = permissions;
                return this;
            }

            public DeviceProperty build() {
                return new Jsii.Proxy(this.containerPath, this.hostPath, this.permissions);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.ContainerPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getImage();

        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public String getExecutionRoleArn() {
            return null;
        }

        @Nullable
        default public Object getFargatePlatformConfiguration() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getJobRoleArn() {
            return null;
        }

        @Nullable
        default public Object getLinuxParameters() {
            return null;
        }

        @Nullable
        default public Object getLogConfiguration() {
            return null;
        }

        @Nullable
        default public Number getMemory() {
            return null;
        }

        @Nullable
        default public Object getMountPoints() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPrivileged() {
            return null;
        }

        @Nullable
        default public Object getReadonlyRootFilesystem() {
            return null;
        }

        @Nullable
        default public Object getResourceRequirements() {
            return null;
        }

        @Nullable
        default public Object getSecrets() {
            return null;
        }

        @Nullable
        default public Object getUlimits() {
            return null;
        }

        @Nullable
        default public String getUser() {
            return null;
        }

        @Nullable
        default public Number getVcpus() {
            return null;
        }

        @Nullable
        default public Object getVolumes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerPropertiesProperty> {
            private String image;
            private List<String> command;
            private Object environment;
            private String executionRoleArn;
            private Object fargatePlatformConfiguration;
            private String instanceType;
            private String jobRoleArn;
            private Object linuxParameters;
            private Object logConfiguration;
            private Number memory;
            private Object mountPoints;
            private Object networkConfiguration;
            private Object privileged;
            private Object readonlyRootFilesystem;
            private Object resourceRequirements;
            private Object secrets;
            private Object ulimits;
            private String user;
            private Number vcpus;
            private Object volumes;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder executionRoleArn(String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            public Builder fargatePlatformConfiguration(FargatePlatformConfigurationProperty fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            public Builder fargatePlatformConfiguration(IResolvable fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder jobRoleArn(String jobRoleArn) {
                this.jobRoleArn = jobRoleArn;
                return this;
            }

            public Builder linuxParameters(LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder linuxParameters(IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder logConfiguration(LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logConfiguration(IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder memory(Number memory) {
                this.memory = memory;
                return this;
            }

            public Builder mountPoints(IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder mountPoints(List<? extends Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder networkConfiguration(IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder privileged(Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder privileged(IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder readonlyRootFilesystem(IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder resourceRequirements(IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder resourceRequirements(List<? extends Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder secrets(IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder secrets(List<? extends Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder ulimits(IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder ulimits(List<? extends Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder user(String user) {
                this.user = user;
                return this;
            }

            public Builder vcpus(Number vcpus) {
                this.vcpus = vcpus;
                return this;
            }

            public Builder volumes(IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            public Builder volumes(List<? extends Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            public ContainerPropertiesProperty build() {
                return new Jsii.Proxy(this.image, this.command, this.environment, this.executionRoleArn, this.fargatePlatformConfiguration, this.instanceType, this.jobRoleArn, this.linuxParameters, this.logConfiguration, this.memory, this.mountPoints, this.networkConfiguration, this.privileged, this.readonlyRootFilesystem, this.resourceRequirements, this.secrets, this.ulimits, this.user, this.vcpus, this.volumes);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_batch.CfnJobDefinition.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessPointId() {
            return null;
        }

        @Nullable
        default public String getIam() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            private String accessPointId;
            private String iam;

            public Builder accessPointId(String accessPointId) {
                this.accessPointId = accessPointId;
                return this;
            }

            public Builder iam(String iam) {
                this.iam = iam;
                return this;
            }

            public AuthorizationConfigProperty build() {
                return new Jsii.Proxy(this.accessPointId, this.iam);
            }
        }
    }
}

