/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cassandra;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.cassandra.CfnTable;
import software.amazon.awscdk.services.cassandra.CfnTableProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_cassandra.CfnTable")
public class CfnTable
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTable.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTable(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTable(@NotNull Construct scope, @NotNull String id, @NotNull CfnTableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getKeyspaceName() {
        return (String)Kernel.get((Object)this, (String)"keyspaceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setKeyspaceName(@NotNull String value) {
        Kernel.set((Object)this, (String)"keyspaceName", (Object)Objects.requireNonNull(value, "keyspaceName is required"));
    }

    @NotNull
    public Object getPartitionKeyColumns() {
        return Kernel.get((Object)this, (String)"partitionKeyColumns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPartitionKeyColumns(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"partitionKeyColumns", (Object)Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    public void setPartitionKeyColumns(@NotNull List<Object> value) {
        Kernel.set((Object)this, (String)"partitionKeyColumns", Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    @Nullable
    public Object getBillingMode() {
        return Kernel.get((Object)this, (String)"billingMode", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBillingMode(@Nullable BillingModeProperty value) {
        Kernel.set((Object)this, (String)"billingMode", (Object)value);
    }

    public void setBillingMode(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"billingMode", (Object)value);
    }

    @Nullable
    public Object getClusteringKeyColumns() {
        return Kernel.get((Object)this, (String)"clusteringKeyColumns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClusteringKeyColumns(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"clusteringKeyColumns", (Object)value);
    }

    public void setClusteringKeyColumns(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"clusteringKeyColumns", value);
    }

    @Nullable
    public Object getPointInTimeRecoveryEnabled() {
        return Kernel.get((Object)this, (String)"pointInTimeRecoveryEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPointInTimeRecoveryEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"pointInTimeRecoveryEnabled", (Object)value);
    }

    public void setPointInTimeRecoveryEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"pointInTimeRecoveryEnabled", (Object)value);
    }

    @Nullable
    public Object getRegularColumns() {
        return Kernel.get((Object)this, (String)"regularColumns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRegularColumns(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"regularColumns", (Object)value);
    }

    public void setRegularColumns(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"regularColumns", value);
    }

    @Nullable
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    public void setTableName(@Nullable String value) {
        Kernel.set((Object)this, (String)"tableName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTable> {
        private final Construct scope;
        private final String id;
        private final CfnTableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTableProps.Builder();
        }

        public Builder keyspaceName(String keyspaceName) {
            this.props.keyspaceName(keyspaceName);
            return this;
        }

        public Builder partitionKeyColumns(IResolvable partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }

        public Builder partitionKeyColumns(List<? extends Object> partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }

        public Builder billingMode(BillingModeProperty billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder billingMode(IResolvable billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder clusteringKeyColumns(IResolvable clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }

        public Builder clusteringKeyColumns(List<? extends Object> clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }

        public Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }

        public Builder pointInTimeRecoveryEnabled(IResolvable pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }

        public Builder regularColumns(IResolvable regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }

        public Builder regularColumns(List<? extends Object> regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnTable build() {
            return new CfnTable(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cassandra.CfnTable.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionedThroughputProperty
    extends JsiiSerializable {
        @NotNull
        public Number getReadCapacityUnits();

        @NotNull
        public Number getWriteCapacityUnits();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            private Number readCapacityUnits;
            private Number writeCapacityUnits;

            public Builder readCapacityUnits(Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            public Builder writeCapacityUnits(Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            public ProvisionedThroughputProperty build() {
                return new Jsii.Proxy(this.readCapacityUnits, this.writeCapacityUnits);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cassandra.CfnTable.ColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnProperty
    extends JsiiSerializable {
        @NotNull
        public String getColumnName();

        @NotNull
        public String getColumnType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnProperty> {
            private String columnName;
            private String columnType;

            public Builder columnName(String columnName) {
                this.columnName = columnName;
                return this;
            }

            public Builder columnType(String columnType) {
                this.columnType = columnType;
                return this;
            }

            public ColumnProperty build() {
                return new Jsii.Proxy(this.columnName, this.columnType);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cassandra.CfnTable.ClusteringKeyColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusteringKeyColumnProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @Nullable
        default public String getOrderBy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusteringKeyColumnProperty> {
            private Object column;
            private String orderBy;

            public Builder column(ColumnProperty column) {
                this.column = column;
                return this;
            }

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder orderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public ClusteringKeyColumnProperty build() {
                return new Jsii.Proxy(this.column, this.orderBy);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cassandra.CfnTable.BillingModeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BillingModeProperty
    extends JsiiSerializable {
        @NotNull
        public String getMode();

        @Nullable
        default public Object getProvisionedThroughput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BillingModeProperty> {
            private String mode;
            private Object provisionedThroughput;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder provisionedThroughput(ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public Builder provisionedThroughput(IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public BillingModeProperty build() {
                return new Jsii.Proxy(this.mode, this.provisionedThroughput);
            }
        }
    }
}

