/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.certificatemanager;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.certificatemanager.CertificateProps;
import software.amazon.awscdk.services.certificatemanager.CertificateValidation;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.certificatemanager.ValidationMethod;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_certificatemanager.Certificate")
public class Certificate
extends Resource
implements ICertificate {
    protected Certificate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Certificate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Certificate(@NotNull Construct scope, @NotNull String id, @NotNull CertificateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ICertificate fromCertificateArn(@NotNull Construct scope, @NotNull String id, @NotNull String certificateArn) {
        return (ICertificate)JsiiObject.jsiiStaticCall(Certificate.class, (String)"fromCertificateArn", (NativeType)NativeType.forClass(ICertificate.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(certificateArn, "certificateArn is required")});
    }

    @Override
    @NotNull
    public Metric metricDaysToExpiry(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricDaysToExpiry", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricDaysToExpiry() {
        return (Metric)Kernel.call((Object)this, (String)"metricDaysToExpiry", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getCertificateArn() {
        return (String)Kernel.get((Object)this, (String)"certificateArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected String getRegion() {
        return (String)Kernel.get((Object)this, (String)"region", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Certificate> {
        private final Construct scope;
        private final String id;
        private final CertificateProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CertificateProps.Builder();
        }

        public Builder domainName(String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder subjectAlternativeNames(List<String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        public Builder validation(CertificateValidation validation) {
            this.props.validation(validation);
            return this;
        }

        @Deprecated
        public Builder validationDomains(Map<String, String> validationDomains) {
            this.props.validationDomains(validationDomains);
            return this;
        }

        @Deprecated
        public Builder validationMethod(ValidationMethod validationMethod) {
            this.props.validationMethod(validationMethod);
            return this;
        }

        public Certificate build() {
            return new Certificate(this.scope, this.id, this.props.build());
        }
    }
}

