/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.cloudfront.CfnDistribution;
import software.amazon.awscdk.services.cloudfront.CfnDistributionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution")
public class CfnDistribution
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDistribution.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDistribution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistribution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDistribution(@NotNull Construct scope, @NotNull String id, @NotNull CfnDistributionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDomainName() {
        return (String)Kernel.get((Object)this, (String)"attrDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getDistributionConfig() {
        return Kernel.get((Object)this, (String)"distributionConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDistributionConfig(@NotNull DistributionConfigProperty value) {
        Kernel.set((Object)this, (String)"distributionConfig", (Object)Objects.requireNonNull(value, "distributionConfig is required"));
    }

    public void setDistributionConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"distributionConfig", (Object)Objects.requireNonNull(value, "distributionConfig is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDistribution> {
        private final Construct scope;
        private final String id;
        private final CfnDistributionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDistributionProps.Builder();
        }

        public Builder distributionConfig(DistributionConfigProperty distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        public Builder distributionConfig(IResolvable distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDistribution build() {
            return new CfnDistribution(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.ViewerCertificateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ViewerCertificateProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAcmCertificateArn() {
            return null;
        }

        @Nullable
        default public Object getCloudFrontDefaultCertificate() {
            return null;
        }

        @Nullable
        default public String getIamCertificateId() {
            return null;
        }

        @Nullable
        default public String getMinimumProtocolVersion() {
            return null;
        }

        @Nullable
        default public String getSslSupportMethod() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ViewerCertificateProperty> {
            private String acmCertificateArn;
            private Object cloudFrontDefaultCertificate;
            private String iamCertificateId;
            private String minimumProtocolVersion;
            private String sslSupportMethod;

            public Builder acmCertificateArn(String acmCertificateArn) {
                this.acmCertificateArn = acmCertificateArn;
                return this;
            }

            public Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            public Builder cloudFrontDefaultCertificate(IResolvable cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            public Builder iamCertificateId(String iamCertificateId) {
                this.iamCertificateId = iamCertificateId;
                return this;
            }

            public Builder minimumProtocolVersion(String minimumProtocolVersion) {
                this.minimumProtocolVersion = minimumProtocolVersion;
                return this;
            }

            public Builder sslSupportMethod(String sslSupportMethod) {
                this.sslSupportMethod = sslSupportMethod;
                return this;
            }

            public ViewerCertificateProperty build() {
                return new Jsii.Proxy(this.acmCertificateArn, this.cloudFrontDefaultCertificate, this.iamCertificateId, this.minimumProtocolVersion, this.sslSupportMethod);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.StatusCodesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatusCodesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getItems();

        @NotNull
        public Number getQuantity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatusCodesProperty> {
            private Object items;
            private Number quantity;

            public Builder items(IResolvable items) {
                this.items = items;
                return this;
            }

            public Builder items(List<? extends Number> items) {
                this.items = items;
                return this;
            }

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public StatusCodesProperty build() {
                return new Jsii.Proxy(this.items, this.quantity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.S3OriginConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OriginConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOriginAccessIdentity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OriginConfigProperty> {
            private String originAccessIdentity;

            public Builder originAccessIdentity(String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            public S3OriginConfigProperty build() {
                return new Jsii.Proxy(this.originAccessIdentity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.RestrictionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RestrictionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getGeoRestriction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RestrictionsProperty> {
            private Object geoRestriction;

            public Builder geoRestriction(GeoRestrictionProperty geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            public Builder geoRestriction(IResolvable geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            public RestrictionsProperty build() {
                return new Jsii.Proxy(this.geoRestriction);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginShieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginShieldProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public String getOriginShieldRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginShieldProperty> {
            private Object enabled;
            private String originShieldRegion;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder originShieldRegion(String originShieldRegion) {
                this.originShieldRegion = originShieldRegion;
                return this;
            }

            public OriginShieldProperty build() {
                return new Jsii.Proxy(this.enabled, this.originShieldRegion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomainName();

        @NotNull
        public String getId();

        @Nullable
        default public Number getConnectionAttempts() {
            return null;
        }

        @Nullable
        default public Number getConnectionTimeout() {
            return null;
        }

        @Nullable
        default public Object getCustomOriginConfig() {
            return null;
        }

        @Nullable
        default public Object getOriginCustomHeaders() {
            return null;
        }

        @Nullable
        default public String getOriginPath() {
            return null;
        }

        @Nullable
        default public Object getOriginShield() {
            return null;
        }

        @Nullable
        default public Object getS3OriginConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginProperty> {
            private String domainName;
            private String id;
            private Number connectionAttempts;
            private Number connectionTimeout;
            private Object customOriginConfig;
            private Object originCustomHeaders;
            private String originPath;
            private Object originShield;
            private Object s3OriginConfig;

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder connectionAttempts(Number connectionAttempts) {
                this.connectionAttempts = connectionAttempts;
                return this;
            }

            public Builder connectionTimeout(Number connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            public Builder customOriginConfig(CustomOriginConfigProperty customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            public Builder customOriginConfig(IResolvable customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            public Builder originCustomHeaders(IResolvable originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            public Builder originCustomHeaders(List<? extends Object> originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            public Builder originPath(String originPath) {
                this.originPath = originPath;
                return this;
            }

            public Builder originShield(OriginShieldProperty originShield) {
                this.originShield = originShield;
                return this;
            }

            public Builder originShield(IResolvable originShield) {
                this.originShield = originShield;
                return this;
            }

            public Builder s3OriginConfig(S3OriginConfigProperty s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            public Builder s3OriginConfig(IResolvable s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            public OriginProperty build() {
                return new Jsii.Proxy(this.domainName, this.id, this.connectionAttempts, this.connectionTimeout, this.customOriginConfig, this.originCustomHeaders, this.originPath, this.originShield, this.s3OriginConfig);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginGroupsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getQuantity();

        @Nullable
        default public Object getItems() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupsProperty> {
            private Number quantity;
            private Object items;

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder items(IResolvable items) {
                this.items = items;
                return this;
            }

            public Builder items(List<? extends Object> items) {
                this.items = items;
                return this;
            }

            public OriginGroupsProperty build() {
                return new Jsii.Proxy(this.quantity, this.items);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFailoverCriteria();

        @NotNull
        public String getId();

        @NotNull
        public Object getMembers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupProperty> {
            private Object failoverCriteria;
            private String id;
            private Object members;

            public Builder failoverCriteria(OriginGroupFailoverCriteriaProperty failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            public Builder failoverCriteria(IResolvable failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder members(OriginGroupMembersProperty members) {
                this.members = members;
                return this;
            }

            public Builder members(IResolvable members) {
                this.members = members;
                return this;
            }

            public OriginGroupProperty build() {
                return new Jsii.Proxy(this.failoverCriteria, this.id, this.members);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginGroupMembersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupMembersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getItems();

        @NotNull
        public Number getQuantity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupMembersProperty> {
            private Object items;
            private Number quantity;

            public Builder items(IResolvable items) {
                this.items = items;
                return this;
            }

            public Builder items(List<? extends Object> items) {
                this.items = items;
                return this;
            }

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public OriginGroupMembersProperty build() {
                return new Jsii.Proxy(this.items, this.quantity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginGroupMemberProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupMemberProperty
    extends JsiiSerializable {
        @NotNull
        public String getOriginId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupMemberProperty> {
            private String originId;

            public Builder originId(String originId) {
                this.originId = originId;
                return this;
            }

            public OriginGroupMemberProperty build() {
                return new Jsii.Proxy(this.originId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupFailoverCriteriaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatusCodes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupFailoverCriteriaProperty> {
            private Object statusCodes;

            public Builder statusCodes(StatusCodesProperty statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            public Builder statusCodes(IResolvable statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            public OriginGroupFailoverCriteriaProperty build() {
                return new Jsii.Proxy(this.statusCodes);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.OriginCustomHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginCustomHeaderProperty
    extends JsiiSerializable {
        @NotNull
        public String getHeaderName();

        @NotNull
        public String getHeaderValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginCustomHeaderProperty> {
            private String headerName;
            private String headerValue;

            public Builder headerName(String headerName) {
                this.headerName = headerName;
                return this;
            }

            public Builder headerValue(String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            public OriginCustomHeaderProperty build() {
                return new Jsii.Proxy(this.headerName, this.headerValue);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public Object getIncludeCookies() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingProperty> {
            private String bucket;
            private Object includeCookies;
            private String prefix;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder includeCookies(Boolean includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            public Builder includeCookies(IResolvable includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public LoggingProperty build() {
                return new Jsii.Proxy(this.bucket, this.includeCookies, this.prefix);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.LegacyS3OriginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LegacyS3OriginProperty
    extends JsiiSerializable {
        @NotNull
        public String getDnsName();

        @Nullable
        default public String getOriginAccessIdentity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LegacyS3OriginProperty> {
            private String dnsName;
            private String originAccessIdentity;

            public Builder dnsName(String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            public Builder originAccessIdentity(String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            public LegacyS3OriginProperty build() {
                return new Jsii.Proxy(this.dnsName, this.originAccessIdentity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.LegacyCustomOriginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LegacyCustomOriginProperty
    extends JsiiSerializable {
        @NotNull
        public String getDnsName();

        @NotNull
        public String getOriginProtocolPolicy();

        @NotNull
        public List<String> getOriginSslProtocols();

        @Nullable
        default public Number getHttpPort() {
            return null;
        }

        @Nullable
        default public Number getHttpsPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LegacyCustomOriginProperty> {
            private String dnsName;
            private String originProtocolPolicy;
            private List<String> originSslProtocols;
            private Number httpPort;
            private Number httpsPort;

            public Builder dnsName(String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            public Builder originProtocolPolicy(String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            public Builder originSslProtocols(List<String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            public Builder httpPort(Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            public Builder httpsPort(Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            public LegacyCustomOriginProperty build() {
                return new Jsii.Proxy(this.dnsName, this.originProtocolPolicy, this.originSslProtocols, this.httpPort, this.httpsPort);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.LambdaFunctionAssociationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaFunctionAssociationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEventType() {
            return null;
        }

        @Nullable
        default public Object getIncludeBody() {
            return null;
        }

        @Nullable
        default public String getLambdaFunctionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaFunctionAssociationProperty> {
            private String eventType;
            private Object includeBody;
            private String lambdaFunctionArn;

            public Builder eventType(String eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder includeBody(Boolean includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            public Builder includeBody(IResolvable includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            public Builder lambdaFunctionArn(String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            public LambdaFunctionAssociationProperty build() {
                return new Jsii.Proxy(this.eventType, this.includeBody, this.lambdaFunctionArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.GeoRestrictionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeoRestrictionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRestrictionType();

        @Nullable
        default public List<String> getLocations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeoRestrictionProperty> {
            private String restrictionType;
            private List<String> locations;

            public Builder restrictionType(String restrictionType) {
                this.restrictionType = restrictionType;
                return this;
            }

            public Builder locations(List<String> locations) {
                this.locations = locations;
                return this;
            }

            public GeoRestrictionProperty build() {
                return new Jsii.Proxy(this.restrictionType, this.locations);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.FunctionAssociationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionAssociationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEventType() {
            return null;
        }

        @Nullable
        default public String getFunctionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionAssociationProperty> {
            private String eventType;
            private String functionArn;

            public Builder eventType(String eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder functionArn(String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            public FunctionAssociationProperty build() {
                return new Jsii.Proxy(this.eventType, this.functionArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.ForwardedValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ForwardedValuesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getQueryString();

        @Nullable
        default public Object getCookies() {
            return null;
        }

        @Nullable
        default public List<String> getHeaders() {
            return null;
        }

        @Nullable
        default public List<String> getQueryStringCacheKeys() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ForwardedValuesProperty> {
            private Object queryString;
            private Object cookies;
            private List<String> headers;
            private List<String> queryStringCacheKeys;

            public Builder queryString(Boolean queryString) {
                this.queryString = queryString;
                return this;
            }

            public Builder queryString(IResolvable queryString) {
                this.queryString = queryString;
                return this;
            }

            public Builder cookies(CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            public Builder cookies(IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            public Builder headers(List<String> headers) {
                this.headers = headers;
                return this;
            }

            public Builder queryStringCacheKeys(List<String> queryStringCacheKeys) {
                this.queryStringCacheKeys = queryStringCacheKeys;
                return this;
            }

            public ForwardedValuesProperty build() {
                return new Jsii.Proxy(this.queryString, this.cookies, this.headers, this.queryStringCacheKeys);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.DistributionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DistributionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public List<String> getAliases() {
            return null;
        }

        @Nullable
        default public Object getCacheBehaviors() {
            return null;
        }

        @Nullable
        default public List<String> getCnamEs() {
            return null;
        }

        @Nullable
        default public String getComment() {
            return null;
        }

        @Nullable
        default public Object getCustomErrorResponses() {
            return null;
        }

        @Nullable
        default public Object getCustomOrigin() {
            return null;
        }

        @Nullable
        default public Object getDefaultCacheBehavior() {
            return null;
        }

        @Nullable
        default public String getDefaultRootObject() {
            return null;
        }

        @Nullable
        default public String getHttpVersion() {
            return null;
        }

        @Nullable
        default public Object getIpv6Enabled() {
            return null;
        }

        @Nullable
        default public Object getLogging() {
            return null;
        }

        @Nullable
        default public Object getOriginGroups() {
            return null;
        }

        @Nullable
        default public Object getOrigins() {
            return null;
        }

        @Nullable
        default public String getPriceClass() {
            return null;
        }

        @Nullable
        default public Object getRestrictions() {
            return null;
        }

        @Nullable
        default public Object getS3Origin() {
            return null;
        }

        @Nullable
        default public Object getViewerCertificate() {
            return null;
        }

        @Nullable
        default public String getWebAclId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DistributionConfigProperty> {
            private Object enabled;
            private List<String> aliases;
            private Object cacheBehaviors;
            private List<String> cnamEs;
            private String comment;
            private Object customErrorResponses;
            private Object customOrigin;
            private Object defaultCacheBehavior;
            private String defaultRootObject;
            private String httpVersion;
            private Object ipv6Enabled;
            private Object logging;
            private Object originGroups;
            private Object origins;
            private String priceClass;
            private Object restrictions;
            private Object s3Origin;
            private Object viewerCertificate;
            private String webAclId;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder aliases(List<String> aliases) {
                this.aliases = aliases;
                return this;
            }

            public Builder cacheBehaviors(IResolvable cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            public Builder cacheBehaviors(List<? extends Object> cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            public Builder cnamEs(List<String> cnamEs) {
                this.cnamEs = cnamEs;
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder customErrorResponses(IResolvable customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            public Builder customErrorResponses(List<? extends Object> customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            public Builder customOrigin(LegacyCustomOriginProperty customOrigin) {
                this.customOrigin = customOrigin;
                return this;
            }

            public Builder customOrigin(IResolvable customOrigin) {
                this.customOrigin = customOrigin;
                return this;
            }

            public Builder defaultCacheBehavior(DefaultCacheBehaviorProperty defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            public Builder defaultCacheBehavior(IResolvable defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            public Builder defaultRootObject(String defaultRootObject) {
                this.defaultRootObject = defaultRootObject;
                return this;
            }

            public Builder httpVersion(String httpVersion) {
                this.httpVersion = httpVersion;
                return this;
            }

            public Builder ipv6Enabled(Boolean ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            public Builder ipv6Enabled(IResolvable ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            public Builder logging(LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            public Builder logging(IResolvable logging) {
                this.logging = logging;
                return this;
            }

            public Builder originGroups(OriginGroupsProperty originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            public Builder originGroups(IResolvable originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            public Builder origins(IResolvable origins) {
                this.origins = origins;
                return this;
            }

            public Builder origins(List<? extends Object> origins) {
                this.origins = origins;
                return this;
            }

            public Builder priceClass(String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            public Builder restrictions(RestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            public Builder restrictions(IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            public Builder s3Origin(LegacyS3OriginProperty s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            public Builder s3Origin(IResolvable s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            public Builder viewerCertificate(ViewerCertificateProperty viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            public Builder viewerCertificate(IResolvable viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            public Builder webAclId(String webAclId) {
                this.webAclId = webAclId;
                return this;
            }

            public DistributionConfigProperty build() {
                return new Jsii.Proxy(this.enabled, this.aliases, this.cacheBehaviors, this.cnamEs, this.comment, this.customErrorResponses, this.customOrigin, this.defaultCacheBehavior, this.defaultRootObject, this.httpVersion, this.ipv6Enabled, this.logging, this.originGroups, this.origins, this.priceClass, this.restrictions, this.s3Origin, this.viewerCertificate, this.webAclId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.DefaultCacheBehaviorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultCacheBehaviorProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetOriginId();

        @NotNull
        public String getViewerProtocolPolicy();

        @Nullable
        default public List<String> getAllowedMethods() {
            return null;
        }

        @Nullable
        default public List<String> getCachedMethods() {
            return null;
        }

        @Nullable
        default public String getCachePolicyId() {
            return null;
        }

        @Nullable
        default public Object getCompress() {
            return null;
        }

        @Nullable
        default public Number getDefaultTtl() {
            return null;
        }

        @Nullable
        default public String getFieldLevelEncryptionId() {
            return null;
        }

        @Nullable
        default public Object getForwardedValues() {
            return null;
        }

        @Nullable
        default public Object getFunctionAssociations() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionAssociations() {
            return null;
        }

        @Nullable
        default public Number getMaxTtl() {
            return null;
        }

        @Nullable
        default public Number getMinTtl() {
            return null;
        }

        @Nullable
        default public String getOriginRequestPolicyId() {
            return null;
        }

        @Nullable
        default public String getRealtimeLogConfigArn() {
            return null;
        }

        @Nullable
        default public Object getSmoothStreaming() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedKeyGroups() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedSigners() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultCacheBehaviorProperty> {
            private String targetOriginId;
            private String viewerProtocolPolicy;
            private List<String> allowedMethods;
            private List<String> cachedMethods;
            private String cachePolicyId;
            private Object compress;
            private Number defaultTtl;
            private String fieldLevelEncryptionId;
            private Object forwardedValues;
            private Object functionAssociations;
            private Object lambdaFunctionAssociations;
            private Number maxTtl;
            private Number minTtl;
            private String originRequestPolicyId;
            private String realtimeLogConfigArn;
            private Object smoothStreaming;
            private List<String> trustedKeyGroups;
            private List<String> trustedSigners;

            public Builder targetOriginId(String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            public Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder cachedMethods(List<String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            public Builder cachePolicyId(String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            public Builder compress(Boolean compress) {
                this.compress = compress;
                return this;
            }

            public Builder compress(IResolvable compress) {
                this.compress = compress;
                return this;
            }

            public Builder defaultTtl(Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            public Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            public Builder forwardedValues(ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder forwardedValues(IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder functionAssociations(IResolvable functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            public Builder functionAssociations(List<? extends Object> functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            public Builder lambdaFunctionAssociations(IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder lambdaFunctionAssociations(List<? extends Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder maxTtl(Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            public Builder minTtl(Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            public Builder originRequestPolicyId(String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            public Builder realtimeLogConfigArn(String realtimeLogConfigArn) {
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                return this;
            }

            public Builder smoothStreaming(Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder smoothStreaming(IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder trustedKeyGroups(List<String> trustedKeyGroups) {
                this.trustedKeyGroups = trustedKeyGroups;
                return this;
            }

            public Builder trustedSigners(List<String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            public DefaultCacheBehaviorProperty build() {
                return new Jsii.Proxy(this.targetOriginId, this.viewerProtocolPolicy, this.allowedMethods, this.cachedMethods, this.cachePolicyId, this.compress, this.defaultTtl, this.fieldLevelEncryptionId, this.forwardedValues, this.functionAssociations, this.lambdaFunctionAssociations, this.maxTtl, this.minTtl, this.originRequestPolicyId, this.realtimeLogConfigArn, this.smoothStreaming, this.trustedKeyGroups, this.trustedSigners);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.CustomOriginConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomOriginConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getOriginProtocolPolicy();

        @Nullable
        default public Number getHttpPort() {
            return null;
        }

        @Nullable
        default public Number getHttpsPort() {
            return null;
        }

        @Nullable
        default public Number getOriginKeepaliveTimeout() {
            return null;
        }

        @Nullable
        default public Number getOriginReadTimeout() {
            return null;
        }

        @Nullable
        default public List<String> getOriginSslProtocols() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomOriginConfigProperty> {
            private String originProtocolPolicy;
            private Number httpPort;
            private Number httpsPort;
            private Number originKeepaliveTimeout;
            private Number originReadTimeout;
            private List<String> originSslProtocols;

            public Builder originProtocolPolicy(String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            public Builder httpPort(Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            public Builder httpsPort(Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            public Builder originKeepaliveTimeout(Number originKeepaliveTimeout) {
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                return this;
            }

            public Builder originReadTimeout(Number originReadTimeout) {
                this.originReadTimeout = originReadTimeout;
                return this;
            }

            public Builder originSslProtocols(List<String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            public CustomOriginConfigProperty build() {
                return new Jsii.Proxy(this.originProtocolPolicy, this.httpPort, this.httpsPort, this.originKeepaliveTimeout, this.originReadTimeout, this.originSslProtocols);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.CustomErrorResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomErrorResponseProperty
    extends JsiiSerializable {
        @NotNull
        public Number getErrorCode();

        @Nullable
        default public Number getErrorCachingMinTtl() {
            return null;
        }

        @Nullable
        default public Number getResponseCode() {
            return null;
        }

        @Nullable
        default public String getResponsePagePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomErrorResponseProperty> {
            private Number errorCode;
            private Number errorCachingMinTtl;
            private Number responseCode;
            private String responsePagePath;

            public Builder errorCode(Number errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            public Builder errorCachingMinTtl(Number errorCachingMinTtl) {
                this.errorCachingMinTtl = errorCachingMinTtl;
                return this;
            }

            public Builder responseCode(Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            public Builder responsePagePath(String responsePagePath) {
                this.responsePagePath = responsePagePath;
                return this;
            }

            public CustomErrorResponseProperty build() {
                return new Jsii.Proxy(this.errorCode, this.errorCachingMinTtl, this.responseCode, this.responsePagePath);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.CookiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CookiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getForward();

        @Nullable
        default public List<String> getWhitelistedNames() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CookiesProperty> {
            private String forward;
            private List<String> whitelistedNames;

            public Builder forward(String forward) {
                this.forward = forward;
                return this;
            }

            public Builder whitelistedNames(List<String> whitelistedNames) {
                this.whitelistedNames = whitelistedNames;
                return this;
            }

            public CookiesProperty build() {
                return new Jsii.Proxy(this.forward, this.whitelistedNames);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CfnDistribution.CacheBehaviorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CacheBehaviorProperty
    extends JsiiSerializable {
        @NotNull
        public String getPathPattern();

        @NotNull
        public String getTargetOriginId();

        @NotNull
        public String getViewerProtocolPolicy();

        @Nullable
        default public List<String> getAllowedMethods() {
            return null;
        }

        @Nullable
        default public List<String> getCachedMethods() {
            return null;
        }

        @Nullable
        default public String getCachePolicyId() {
            return null;
        }

        @Nullable
        default public Object getCompress() {
            return null;
        }

        @Nullable
        default public Number getDefaultTtl() {
            return null;
        }

        @Nullable
        default public String getFieldLevelEncryptionId() {
            return null;
        }

        @Nullable
        default public Object getForwardedValues() {
            return null;
        }

        @Nullable
        default public Object getFunctionAssociations() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionAssociations() {
            return null;
        }

        @Nullable
        default public Number getMaxTtl() {
            return null;
        }

        @Nullable
        default public Number getMinTtl() {
            return null;
        }

        @Nullable
        default public String getOriginRequestPolicyId() {
            return null;
        }

        @Nullable
        default public String getRealtimeLogConfigArn() {
            return null;
        }

        @Nullable
        default public Object getSmoothStreaming() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedKeyGroups() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedSigners() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CacheBehaviorProperty> {
            private String pathPattern;
            private String targetOriginId;
            private String viewerProtocolPolicy;
            private List<String> allowedMethods;
            private List<String> cachedMethods;
            private String cachePolicyId;
            private Object compress;
            private Number defaultTtl;
            private String fieldLevelEncryptionId;
            private Object forwardedValues;
            private Object functionAssociations;
            private Object lambdaFunctionAssociations;
            private Number maxTtl;
            private Number minTtl;
            private String originRequestPolicyId;
            private String realtimeLogConfigArn;
            private Object smoothStreaming;
            private List<String> trustedKeyGroups;
            private List<String> trustedSigners;

            public Builder pathPattern(String pathPattern) {
                this.pathPattern = pathPattern;
                return this;
            }

            public Builder targetOriginId(String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            public Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder cachedMethods(List<String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            public Builder cachePolicyId(String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            public Builder compress(Boolean compress) {
                this.compress = compress;
                return this;
            }

            public Builder compress(IResolvable compress) {
                this.compress = compress;
                return this;
            }

            public Builder defaultTtl(Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            public Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            public Builder forwardedValues(ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder forwardedValues(IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder functionAssociations(IResolvable functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            public Builder functionAssociations(List<? extends Object> functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            public Builder lambdaFunctionAssociations(IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder lambdaFunctionAssociations(List<? extends Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder maxTtl(Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            public Builder minTtl(Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            public Builder originRequestPolicyId(String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            public Builder realtimeLogConfigArn(String realtimeLogConfigArn) {
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                return this;
            }

            public Builder smoothStreaming(Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder smoothStreaming(IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder trustedKeyGroups(List<String> trustedKeyGroups) {
                this.trustedKeyGroups = trustedKeyGroups;
                return this;
            }

            public Builder trustedSigners(List<String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            public CacheBehaviorProperty build() {
                return new Jsii.Proxy(this.pathPattern, this.targetOriginId, this.viewerProtocolPolicy, this.allowedMethods, this.cachedMethods, this.cachePolicyId, this.compress, this.defaultTtl, this.fieldLevelEncryptionId, this.forwardedValues, this.functionAssociations, this.lambdaFunctionAssociations, this.maxTtl, this.minTtl, this.originRequestPolicyId, this.realtimeLogConfigArn, this.smoothStreaming, this.trustedKeyGroups, this.trustedSigners);
            }
        }
    }
}

