/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudfront.AliasConfiguration;
import software.amazon.awscdk.services.cloudfront.CfnDistribution;
import software.amazon.awscdk.services.cloudfront.CloudFrontWebDistributionAttributes;
import software.amazon.awscdk.services.cloudfront.CloudFrontWebDistributionProps;
import software.amazon.awscdk.services.cloudfront.GeoRestriction;
import software.amazon.awscdk.services.cloudfront.HttpVersion;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.cloudfront.LoggingConfiguration;
import software.amazon.awscdk.services.cloudfront.PriceClass;
import software.amazon.awscdk.services.cloudfront.SourceConfiguration;
import software.amazon.awscdk.services.cloudfront.ViewerCertificate;
import software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_cloudfront.CloudFrontWebDistribution")
public class CloudFrontWebDistribution
extends Resource
implements IDistribution {
    protected CloudFrontWebDistribution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFrontWebDistribution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFrontWebDistribution(@NotNull Construct scope, @NotNull String id, @NotNull CloudFrontWebDistributionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDistribution fromDistributionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull CloudFrontWebDistributionAttributes attrs) {
        return (IDistribution)JsiiObject.jsiiStaticCall(CloudFrontWebDistribution.class, (String)"fromDistributionAttributes", (NativeType)NativeType.forClass(IDistribution.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public String getDistributionDomainName() {
        return (String)Kernel.get((Object)this, (String)"distributionDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDistributionId() {
        return (String)Kernel.get((Object)this, (String)"distributionId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Deprecated
    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IBucket getLoggingBucket() {
        return (IBucket)Kernel.get((Object)this, (String)"loggingBucket", (NativeType)NativeType.forClass(IBucket.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudFrontWebDistribution> {
        private final Construct scope;
        private final String id;
        private final CloudFrontWebDistributionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CloudFrontWebDistributionProps.Builder();
        }

        public Builder originConfigs(List<? extends SourceConfiguration> originConfigs) {
            this.props.originConfigs(originConfigs);
            return this;
        }

        @Deprecated
        public Builder aliasConfiguration(AliasConfiguration aliasConfiguration) {
            this.props.aliasConfiguration(aliasConfiguration);
            return this;
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder defaultRootObject(String defaultRootObject) {
            this.props.defaultRootObject(defaultRootObject);
            return this;
        }

        public Builder enableIpV6(Boolean enableIpV6) {
            this.props.enableIpV6(enableIpV6);
            return this;
        }

        public Builder errorConfigurations(List<? extends CfnDistribution.CustomErrorResponseProperty> errorConfigurations) {
            this.props.errorConfigurations(errorConfigurations);
            return this;
        }

        public Builder geoRestriction(GeoRestriction geoRestriction) {
            this.props.geoRestriction(geoRestriction);
            return this;
        }

        public Builder httpVersion(HttpVersion httpVersion) {
            this.props.httpVersion(httpVersion);
            return this;
        }

        public Builder loggingConfig(LoggingConfiguration loggingConfig) {
            this.props.loggingConfig(loggingConfig);
            return this;
        }

        public Builder priceClass(PriceClass priceClass) {
            this.props.priceClass(priceClass);
            return this;
        }

        public Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.props.viewerCertificate(viewerCertificate);
            return this;
        }

        public Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.props.viewerProtocolPolicy(viewerProtocolPolicy);
            return this;
        }

        public Builder webAclId(String webAclId) {
            this.props.webAclId(webAclId);
            return this;
        }

        public CloudFrontWebDistribution build() {
            return new CloudFrontWebDistribution(this.scope, this.id, this.props.build());
        }
    }
}

