/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.codebuild.CfnReportGroup;
import software.amazon.awscdk.services.codebuild.CfnReportGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnReportGroup")
public class CfnReportGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnReportGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnReportGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReportGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnReportGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnReportGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getExportConfig() {
        return Kernel.get((Object)this, (String)"exportConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setExportConfig(@NotNull ReportExportConfigProperty value) {
        Kernel.set((Object)this, (String)"exportConfig", (Object)Objects.requireNonNull(value, "exportConfig is required"));
    }

    public void setExportConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"exportConfig", (Object)Objects.requireNonNull(value, "exportConfig is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getDeleteReports() {
        return Kernel.get((Object)this, (String)"deleteReports", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeleteReports(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"deleteReports", (Object)value);
    }

    public void setDeleteReports(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deleteReports", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnReportGroup> {
        private final Construct scope;
        private final String id;
        private final CfnReportGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnReportGroupProps.Builder();
        }

        public Builder exportConfig(ReportExportConfigProperty exportConfig) {
            this.props.exportConfig(exportConfig);
            return this;
        }

        public Builder exportConfig(IResolvable exportConfig) {
            this.props.exportConfig(exportConfig);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder deleteReports(Boolean deleteReports) {
            this.props.deleteReports(deleteReports);
            return this;
        }

        public Builder deleteReports(IResolvable deleteReports) {
            this.props.deleteReports(deleteReports);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnReportGroup build() {
            return new CfnReportGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnReportGroup.S3ReportExportConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ReportExportConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public String getBucketOwner() {
            return null;
        }

        @Nullable
        default public Object getEncryptionDisabled() {
            return null;
        }

        @Nullable
        default public String getEncryptionKey() {
            return null;
        }

        @Nullable
        default public String getPackaging() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ReportExportConfigProperty> {
            private String bucket;
            private String bucketOwner;
            private Object encryptionDisabled;
            private String encryptionKey;
            private String packaging;
            private String path;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder bucketOwner(String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            public Builder encryptionDisabled(Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            public Builder encryptionDisabled(IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            public Builder encryptionKey(String encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            public Builder packaging(String packaging) {
                this.packaging = packaging;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public S3ReportExportConfigProperty build() {
                return new Jsii.Proxy(this.bucket, this.bucketOwner, this.encryptionDisabled, this.encryptionKey, this.packaging, this.path);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnReportGroup.ReportExportConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReportExportConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getExportConfigType();

        @Nullable
        default public Object getS3Destination() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReportExportConfigProperty> {
            private String exportConfigType;
            private Object s3Destination;

            public Builder exportConfigType(String exportConfigType) {
                this.exportConfigType = exportConfigType;
                return this;
            }

            public Builder s3Destination(S3ReportExportConfigProperty s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            public Builder s3Destination(IResolvable s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            public ReportExportConfigProperty build() {
                return new Jsii.Proxy(this.exportConfigType, this.s3Destination);
            }
        }
    }
}

