/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.codebuild.Cache;
import software.amazon.awscdk.services.codebuild.CommonProjectProps;
import software.amazon.awscdk.services.codebuild.IArtifacts;
import software.amazon.awscdk.services.codebuild.IFileSystemLocation;
import software.amazon.awscdk.services.codebuild.ISource;
import software.amazon.awscdk.services.codebuild.LoggingOptions;
import software.amazon.awscdk.services.codebuild.ProjectProps;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.ProjectProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ProjectProps
extends JsiiSerializable,
CommonProjectProps {
    @Nullable
    default public IArtifacts getArtifacts() {
        return null;
    }

    @Nullable
    default public List<IArtifacts> getSecondaryArtifacts() {
        return null;
    }

    @Nullable
    default public List<ISource> getSecondarySources() {
        return null;
    }

    @Nullable
    default public ISource getSource() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ProjectProps> {
        private IArtifacts artifacts;
        private List<IArtifacts> secondaryArtifacts;
        private List<ISource> secondarySources;
        private ISource source;
        private Boolean allowAllOutbound;
        private Boolean badge;
        private BuildSpec buildSpec;
        private Cache cache;
        private Boolean checkSecretsInPlainTextEnvVariables;
        private Number concurrentBuildLimit;
        private String description;
        private IKey encryptionKey;
        private BuildEnvironment environment;
        private Map<String, BuildEnvironmentVariable> environmentVariables;
        private List<IFileSystemLocation> fileSystemLocations;
        private Boolean grantReportGroupPermissions;
        private LoggingOptions logging;
        private String projectName;
        private Duration queuedTimeout;
        private IRole role;
        private List<ISecurityGroup> securityGroups;
        private SubnetSelection subnetSelection;
        private Duration timeout;
        private IVpc vpc;

        public Builder artifacts(IArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public Builder secondaryArtifacts(List<? extends IArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = secondaryArtifacts;
            return this;
        }

        public Builder secondarySources(List<? extends ISource> secondarySources) {
            this.secondarySources = secondarySources;
            return this;
        }

        public Builder source(ISource source) {
            this.source = source;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder badge(Boolean badge) {
            this.badge = badge;
            return this;
        }

        public Builder buildSpec(BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public Builder cache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Builder checkSecretsInPlainTextEnvVariables(Boolean checkSecretsInPlainTextEnvVariables) {
            this.checkSecretsInPlainTextEnvVariables = checkSecretsInPlainTextEnvVariables;
            return this;
        }

        public Builder concurrentBuildLimit(Number concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder environment(BuildEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public Builder environmentVariables(Map<String, ? extends BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder fileSystemLocations(List<? extends IFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = fileSystemLocations;
            return this;
        }

        public Builder grantReportGroupPermissions(Boolean grantReportGroupPermissions) {
            this.grantReportGroupPermissions = grantReportGroupPermissions;
            return this;
        }

        public Builder logging(LoggingOptions logging) {
            this.logging = logging;
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder queuedTimeout(Duration queuedTimeout) {
            this.queuedTimeout = queuedTimeout;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ProjectProps build() {
            return new Jsii.Proxy(this.artifacts, this.secondaryArtifacts, this.secondarySources, this.source, this.allowAllOutbound, this.badge, this.buildSpec, this.cache, this.checkSecretsInPlainTextEnvVariables, this.concurrentBuildLimit, this.description, this.encryptionKey, this.environment, this.environmentVariables, this.fileSystemLocations, this.grantReportGroupPermissions, this.logging, this.projectName, this.queuedTimeout, this.role, this.securityGroups, this.subnetSelection, this.timeout, this.vpc);
        }
    }
}

