/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.assets.FollowMode;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.AssetHashType;
import software.amazon.awscdk.core.BundlingOptions;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IgnoreMode;
import software.amazon.awscdk.core.SymlinkFollowMode;
import software.amazon.awscdk.services.ecs.EnvironmentFile;
import software.amazon.awscdk.services.ecs.EnvironmentFileConfig;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.s3.assets.AssetOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_ecs.AssetEnvironmentFile")
public class AssetEnvironmentFile
extends EnvironmentFile {
    protected AssetEnvironmentFile(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetEnvironmentFile(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetEnvironmentFile(@NotNull String path, @Nullable AssetOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required"), options});
    }

    public AssetEnvironmentFile(@NotNull String path) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @Override
    @NotNull
    public EnvironmentFileConfig bind(@NotNull Construct scope) {
        return (EnvironmentFileConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(EnvironmentFileConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    public String getPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"path", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetEnvironmentFile> {
        private final String path;
        private AssetOptions.Builder options;

        public static Builder create(String path) {
            return new Builder(path);
        }

        private Builder(String path) {
            this.path = path;
        }

        public Builder exclude(List<String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        @Deprecated
        public Builder follow(FollowMode follow) {
            this.options().follow(follow);
            return this;
        }

        public Builder ignoreMode(IgnoreMode ignoreMode) {
            this.options().ignoreMode(ignoreMode);
            return this;
        }

        public Builder followSymlinks(SymlinkFollowMode followSymlinks) {
            this.options().followSymlinks(followSymlinks);
            return this;
        }

        public Builder assetHash(String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        public Builder assetHashType(AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        public Builder bundling(BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        public Builder readers(List<? extends IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        @Deprecated
        public Builder sourceHash(String sourceHash) {
            this.options().sourceHash(sourceHash);
            return this;
        }

        public AssetEnvironmentFile build() {
            return new AssetEnvironmentFile(this.path, this.options != null ? this.options.build() : null);
        }

        private AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new AssetOptions.Builder();
            }
            return this.options;
        }
    }
}

