/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.eks.CfnFargateProfile;
import software.amazon.awscdk.services.eks.CfnFargateProfileProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_eks.CfnFargateProfile")
public class CfnFargateProfile
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFargateProfile.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFargateProfile(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFargateProfile(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFargateProfile(@NotNull Construct scope, @NotNull String id, @NotNull CfnFargateProfileProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@NotNull String value) {
        Kernel.set((Object)this, (String)"clusterName", (Object)Objects.requireNonNull(value, "clusterName is required"));
    }

    @NotNull
    public String getPodExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"podExecutionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setPodExecutionRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"podExecutionRoleArn", (Object)Objects.requireNonNull(value, "podExecutionRoleArn is required"));
    }

    @NotNull
    public Object getSelectors() {
        return Kernel.get((Object)this, (String)"selectors", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSelectors(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"selectors", (Object)Objects.requireNonNull(value, "selectors is required"));
    }

    public void setSelectors(@NotNull List<Object> value) {
        Kernel.set((Object)this, (String)"selectors", Objects.requireNonNull(value, "selectors is required"));
    }

    @Nullable
    public String getFargateProfileName() {
        return (String)Kernel.get((Object)this, (String)"fargateProfileName", (NativeType)NativeType.forClass(String.class));
    }

    public void setFargateProfileName(@Nullable String value) {
        Kernel.set((Object)this, (String)"fargateProfileName", (Object)value);
    }

    @Nullable
    public List<String> getSubnets() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"subnets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSubnets(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"subnets", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFargateProfile> {
        private final Construct scope;
        private final String id;
        private final CfnFargateProfileProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFargateProfileProps.Builder();
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder podExecutionRoleArn(String podExecutionRoleArn) {
            this.props.podExecutionRoleArn(podExecutionRoleArn);
            return this;
        }

        public Builder selectors(IResolvable selectors) {
            this.props.selectors(selectors);
            return this;
        }

        public Builder selectors(List<? extends Object> selectors) {
            this.props.selectors(selectors);
            return this;
        }

        public Builder fargateProfileName(String fargateProfileName) {
            this.props.fargateProfileName(fargateProfileName);
            return this;
        }

        public Builder subnets(List<String> subnets) {
            this.props.subnets(subnets);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnFargateProfile build() {
            return new CfnFargateProfile(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_eks.CfnFargateProfile.SelectorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SelectorProperty
    extends JsiiSerializable {
        @NotNull
        public String getNamespace();

        @Nullable
        default public Object getLabels() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SelectorProperty> {
            private String namespace;
            private Object labels;

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder labels(IResolvable labels) {
                this.labels = labels;
                return this;
            }

            public Builder labels(List<? extends Object> labels) {
                this.labels = labels;
                return this;
            }

            public SelectorProperty build() {
                return new Jsii.Proxy(this.namespace, this.labels);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_eks.CfnFargateProfile.LabelProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LabelProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LabelProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public LabelProperty build() {
                return new Jsii.Proxy(this.key, this.value);
            }
        }
    }
}

