/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.CapacityType;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.eks.LaunchTemplateSpec;
import software.amazon.awscdk.services.eks.NodegroupAmiType;
import software.amazon.awscdk.services.eks.NodegroupOptions;
import software.amazon.awscdk.services.eks.NodegroupProps;
import software.amazon.awscdk.services.eks.NodegroupRemoteAccess;
import software.amazon.awscdk.services.eks.TaintSpec;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk.aws_eks.NodegroupProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface NodegroupProps
extends JsiiSerializable,
NodegroupOptions {
    @NotNull
    public ICluster getCluster();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NodegroupProps> {
        private ICluster cluster;
        private NodegroupAmiType amiType;
        private CapacityType capacityType;
        private Number desiredSize;
        private Number diskSize;
        private Boolean forceUpdate;
        private InstanceType instanceType;
        private List<InstanceType> instanceTypes;
        private Map<String, String> labels;
        private LaunchTemplateSpec launchTemplateSpec;
        private Number maxSize;
        private Number minSize;
        private String nodegroupName;
        private IRole nodeRole;
        private String releaseVersion;
        private NodegroupRemoteAccess remoteAccess;
        private SubnetSelection subnets;
        private Map<String, String> tags;
        private List<TaintSpec> taints;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder amiType(NodegroupAmiType amiType) {
            this.amiType = amiType;
            return this;
        }

        public Builder capacityType(CapacityType capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        public Builder desiredSize(Number desiredSize) {
            this.desiredSize = desiredSize;
            return this;
        }

        public Builder diskSize(Number diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        @Deprecated
        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder instanceTypes(List<? extends InstanceType> instanceTypes) {
            this.instanceTypes = instanceTypes;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder launchTemplateSpec(LaunchTemplateSpec launchTemplateSpec) {
            this.launchTemplateSpec = launchTemplateSpec;
            return this;
        }

        public Builder maxSize(Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder minSize(Number minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public Builder nodeRole(IRole nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public Builder remoteAccess(NodegroupRemoteAccess remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder taints(List<? extends TaintSpec> taints) {
            this.taints = taints;
            return this;
        }

        public NodegroupProps build() {
            return new Jsii.Proxy(this.cluster, this.amiType, this.capacityType, this.desiredSize, this.diskSize, this.forceUpdate, this.instanceType, this.instanceTypes, this.labels, this.launchTemplateSpec, this.maxSize, this.minSize, this.nodegroupName, this.nodeRole, this.releaseVersion, this.remoteAccess, this.subnets, this.tags, this.taints);
        }
    }
}

