/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.globalaccelerator;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.globalaccelerator.ClientAffinity;
import software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol;
import software.amazon.awscdk.services.globalaccelerator.EndpointGroup;
import software.amazon.awscdk.services.globalaccelerator.EndpointGroupOptions;
import software.amazon.awscdk.services.globalaccelerator.IAccelerator;
import software.amazon.awscdk.services.globalaccelerator.IListener;
import software.amazon.awscdk.services.globalaccelerator.ListenerProps;
import software.amazon.awscdk.services.globalaccelerator.PortRange;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_globalaccelerator.Listener")
public class Listener
extends Resource
implements IListener {
    protected Listener(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Listener(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Listener(@NotNull Construct scope, @NotNull String id, @NotNull ListenerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IListener fromListenerArn(@NotNull Construct scope, @NotNull String id, @NotNull String listenerArn) {
        return (IListener)JsiiObject.jsiiStaticCall(Listener.class, (String)"fromListenerArn", (NativeType)NativeType.forClass(IListener.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(listenerArn, "listenerArn is required")});
    }

    @NotNull
    public EndpointGroup addEndpointGroup(@NotNull String id, @Nullable EndpointGroupOptions options) {
        return (EndpointGroup)Kernel.call((Object)this, (String)"addEndpointGroup", (NativeType)NativeType.forClass(EndpointGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public EndpointGroup addEndpointGroup(@NotNull String id) {
        return (EndpointGroup)Kernel.call((Object)this, (String)"addEndpointGroup", (NativeType)NativeType.forClass(EndpointGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public String getListenerArn() {
        return (String)Kernel.get((Object)this, (String)"listenerArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getListenerName() {
        return (String)Kernel.get((Object)this, (String)"listenerName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Listener> {
        private final Construct scope;
        private final String id;
        private final ListenerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ListenerProps.Builder();
        }

        public Builder portRanges(List<? extends PortRange> portRanges) {
            this.props.portRanges(portRanges);
            return this;
        }

        public Builder clientAffinity(ClientAffinity clientAffinity) {
            this.props.clientAffinity(clientAffinity);
            return this;
        }

        public Builder listenerName(String listenerName) {
            this.props.listenerName(listenerName);
            return this;
        }

        public Builder protocol(ConnectionProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder accelerator(IAccelerator accelerator) {
            this.props.accelerator(accelerator);
            return this;
        }

        public Listener build() {
            return new Listener(this.scope, this.id, this.props.build());
        }
    }
}

